/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.TestCase;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HierarchyViewTestFixture {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure) {
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, expectedStructure, null);
    }

    public static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull File expectedFile) throws IOException {
        HierarchyViewTestFixture.doHierarchyTest(treeStructure, FileUtil.loadFile((File)expectedFile), expectedFile);
    }

    private static void doHierarchyTest(@NotNull HierarchyTreeStructure treeStructure, @NotNull String expectedStructure, @Nullable File expectedFile) {
        try {
            HierarchyViewTestFixture.checkHierarchyTreeStructure(treeStructure, JDOMUtil.load((CharSequence)expectedStructure));
        }
        catch (Throwable e) {
            String actual = HierarchyViewTestFixture.dump(treeStructure, null, 0);
            if (!expectedStructure.equals(actual)) {
                throw new FileComparisonFailure("XML structure comparison for your convenience, actual failure details BELOW", expectedStructure, actual, expectedFile == null ? null : expectedFile.getAbsolutePath());
            }
            e.printStackTrace();
        }
    }

    @NotNull
    public static String dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor, int level) {
        StringBuilder s = new StringBuilder();
        HierarchyViewTestFixture.dump(treeStructure, descriptor, level, s);
        return s.toString();
    }

    private static void dump(@NotNull HierarchyTreeStructure treeStructure, @Nullable HierarchyNodeDescriptor descriptor, int level, @NotNull StringBuilder b) {
        if (level > 10) {
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            b.append("<Probably infinite part skipped>\n");
            return;
        }
        if (descriptor == null) {
            descriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        }
        for (int i = 0; i < level; ++i) {
            b.append("  ");
        }
        descriptor.update();
        b.append("<node text=\"").append(descriptor.getHighlightedText().getText()).append("\"").append(treeStructure.getBaseDescriptor() == descriptor ? " base=\"true\"" : "");
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        if (children.length > 0) {
            b.append(">\n");
            for (Object o : children) {
                HierarchyNodeDescriptor d = (HierarchyNodeDescriptor)o;
                HierarchyViewTestFixture.dump(treeStructure, d, level + 1, b);
            }
            for (int i = 0; i < level; ++i) {
                b.append("  ");
            }
            b.append("</node>\n");
        } else {
            b.append("/>\n");
        }
    }

    private static void checkHierarchyTreeStructure(@NotNull HierarchyTreeStructure treeStructure, @Nullable Element rootElement) {
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        rootNodeDescriptor.update();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement);
    }

    private static void checkNodeDescriptorRecursively(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor, @NotNull Element expectedElement) {
        HierarchyViewTestFixture.checkBaseNode(treeStructure, descriptor, expectedElement);
        HierarchyViewTestFixture.checkContent(descriptor, expectedElement);
        HierarchyViewTestFixture.checkChildren(treeStructure, descriptor, expectedElement);
    }

    private static void checkBaseNode(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor, @NotNull Element expectedElement) {
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        TestCase.assertEquals((String)"Incorrect base node", (boolean)mustBeBase, (baseDescriptor == descriptor ? 1 : 0) != 0);
    }

    private static void checkContent(@NotNull HierarchyNodeDescriptor descriptor, @NotNull Element expectedElement) {
        TestCase.assertEquals((String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor.getHighlightedText().getText());
    }

    private static void checkChildren(@NotNull HierarchyTreeStructure treeStructure, @NotNull HierarchyNodeDescriptor descriptor, @NotNull Element element) {
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        ArrayList<Element> expectedChildren = new ArrayList<Element>(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor.getHighlightedText().getText() + "]:\n");
        for (Object child2 : children) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)child2;
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        TestCase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children.length);
        Arrays.sort(children, Comparator.comparing(child -> ((HierarchyNodeDescriptor)child).getHighlightedText().getText()));
        expectedChildren.sort(Comparator.comparing(child -> child.getAttributeValue(TEXT_ATTR_NAME)));
        Iterator iterator = expectedChildren.iterator();
        for (Object child3 : children) {
            HierarchyViewTestFixture.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)child3, (Element)iterator.next());
        }
    }
}

