/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.HeavyPlatformTestCase;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class TempFiles {
    private final Collection<Path> myFilesToDelete;

    public TempFiles(@NotNull Collection<Path> filesToDelete) {
        this.myFilesToDelete = filesToDelete;
    }

    @NotNull
    public VirtualFile createVFile(@NotNull String prefix) {
        return TempFiles.getVFileByFile(this.createTempFile(prefix));
    }

    @NotNull
    public VirtualFile createVFile(@NotNull String prefix, String postfix) {
        return TempFiles.getVFileByFile(this.createTempFile(prefix, postfix));
    }

    @NotNull
    public File createTempFile(@NotNull String prefix) {
        return this.createTempFile(prefix, null);
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix) {
        return this.createTempFile(prefix, suffix, true);
    }

    @NotNull
    public File createTempFile(@NotNull String prefix, String suffix, boolean isRefreshVfs) {
        try {
            File tempFile = FileUtilRt.createTempFile((String)prefix, (String)suffix, (boolean)false);
            this.tempFileCreated(tempFile.toPath());
            if (isRefreshVfs) {
                TempFiles.getVFileByFile(tempFile);
            }
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void tempFileCreated(@NotNull Path tempFile) {
        this.myFilesToDelete.add(tempFile);
    }

    public static VirtualFile getVFileByFile(@NotNull File tempFile) {
        return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(tempFile);
    }

    @NotNull
    public File createTempDir() {
        return this.createTempDir("dir");
    }

    @NotNull
    private File createTempDir(@NotNull String prefix) {
        try {
            File dir = FileUtil.createTempDirectory((String)prefix, (String)"test", (boolean)false);
            this.tempFileCreated(dir.toPath());
            HeavyPlatformTestCase.synchronizeTempDirVfs(TempFiles.getVFileByFile(dir));
            return dir;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public VirtualFile createTempVDir() {
        return this.createTempVDir("dir");
    }

    @NotNull
    public VirtualFile createTempVDir(@NotNull String prefix) {
        return TempFiles.getVFileByFile(this.createTempDir(prefix));
    }

    public void deleteAll() {
        for (Path file2 : this.myFilesToDelete) {
            PathKt.delete((Path)file2);
        }
    }

    @NotNull
    public VirtualFile createVFile(final @NotNull VirtualFile parentDir, final @NotNull String name, final @NotNull String text) {
        return (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile virtualFile = parentDir.createChildData((Object)this, name);
                    VfsUtil.saveText((VirtualFile)virtualFile, (String)(text + "\n"));
                    return virtualFile;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }
}

