/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ExpandMacroToPathMap;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.fileEditor.impl.FileEditorProviderManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.ServiceContainerUtil;
import com.intellij.testFramework.fixtures.BasePlatformTestCase;
import com.intellij.ui.docking.DockManager;
import com.intellij.util.ui.UIUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public abstract class FileEditorManagerTestCase
extends BasePlatformTestCase {
    protected FileEditorManagerImpl myManager;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.myManager = new FileEditorManagerImpl(this.getProject());
        ServiceContainerUtil.registerComponentInstance((ComponentManager)this.getProject(), FileEditorManager.class, this.myManager, this.getTestRootDisposable());
        ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
    }

    @Override
    protected void tearDown() throws Exception {
        RunAll.runAll(() -> {
            this.myManager.closeAllFiles();
            EditorHistoryManager.getInstance((Project)this.getProject()).removeAllFiles();
            ((FileEditorProviderManagerImpl)FileEditorProviderManager.getInstance()).clearSelectedProviders();
        }, () -> Disposer.dispose((Disposable)this.myManager), () -> {
            this.myManager = null;
            DockManager dockManager = (DockManager)this.getProject().getServiceIfCreated(DockManager.class);
            Set containers = dockManager == null ? Collections.emptySet() : dockManager.getContainers();
            FileEditorManagerTestCase.assertEmpty(containers);
        }, () -> super.tearDown());
    }

    @NotNull
    protected VirtualFile getFile(@NotNull String path) {
        String fullPath = this.getTestDataPath() + path;
        VirtualFile file2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
        FileEditorManagerTestCase.assertNotNull((String)("Can't find " + fullPath), (Object)file2);
        return file2;
    }

    protected void openFiles(@NotNull String femSerialisedText) throws IOException, JDOMException, InterruptedException, ExecutionException {
        Element rootElement = JDOMUtil.load((CharSequence)femSerialisedText);
        ExpandMacroToPathMap map = new ExpandMacroToPathMap();
        map.addMacroExpand("PROJECT_DIR", this.getTestDataPath());
        map.substitute(rootElement, true, true);
        this.myManager.loadState(rootElement);
        Future future = ApplicationManager.getApplication().executeOnPooledThread(() -> this.myManager.getMainSplitters().openFiles());
        while (true) {
            try {
                future.get(100L, TimeUnit.MILLISECONDS);
                return;
            }
            catch (TimeoutException e) {
                UIUtil.dispatchAllInvocationEvents();
                continue;
            }
            break;
        }
    }
}

