/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.formatter;

import com.intellij.application.options.CodeStyle;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FormatterTestCase
extends LightPlatformTestCase {
    protected boolean doReformatRangeTest;
    protected TextRange myTextRange;
    protected EditorImpl myEditor;
    protected PsiFile myFile;
    private final Disposable myBeforeParentDisposeDisposable = Disposer.newDisposable();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        FormatterTestCase.assertFalse((boolean)CodeStyle.usesOwnSettings((Project)this.getProject()));
    }

    protected void doTest(String resultNumber) throws Exception {
        this.doTestForResult(this.getTestName(true), resultNumber);
    }

    protected void doTest() throws Exception {
        this.doTest(null);
    }

    private void doTestForResult(String testName, String resultNumber) throws Exception {
        this.doTest(testName + "." + this.getFileExtension(), testName + "_after." + this.getFileExtension(), resultNumber);
    }

    protected void doTest(String fileNameBefore, String fileNameAfter, String resultNumber) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore, null), this.loadFile(fileNameAfter, resultNumber));
    }

    protected final void doTest(@NonNls String fileNameBefore, @NonNls String fileNameAfter) throws Exception {
        this.doTextTest(this.loadFile(fileNameBefore + "." + this.getFileExtension(), null), this.loadFile(fileNameAfter + "." + this.getFileExtension(), null));
    }

    protected void doTextTest(String text, String textAfter) {
        String fileName = "before." + this.getFileExtension();
        PsiFile file2 = this.createFileFromText(text, fileName, PsiFileFactory.getInstance((Project)this.getProject()));
        this.checkDocument(file2, text, textAfter);
    }

    protected PsiFile createFileFromText(String text, String fileName, PsiFileFactory fileFactory) {
        return fileFactory.createFileFromText(fileName, this.getFileType(fileName), (CharSequence)text, LocalTimeCounter.currentTime(), true, false);
    }

    protected FileType getFileType(String fileName) {
        return FileTypeManager.getInstance().getFileTypeByFileName(fileName);
    }

    @Override
    @NotNull
    public final Disposable getTestRootDisposable() {
        return this.myBeforeParentDisposeDisposable;
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (this.myFile != null) {
                ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).clearUndoRedoQueueInTests(this.myFile.getVirtualFile());
                FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myFile.getVirtualFile());
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        this.myEditor = null;
        this.myFile = null;
        try {
            Disposer.dispose((Disposable)this.myBeforeParentDisposeDisposable);
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean doCheckDocumentUpdate() {
        return false;
    }

    protected void checkDocument(PsiFile file2, String text, String textAfter) {
        Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file2);
        assert (document != null);
        if (this.doCheckDocumentUpdate()) {
            EditorImpl editor = (EditorImpl)FileEditorManager.getInstance((Project)this.getProject()).openTextEditor(new OpenFileDescriptor(this.getProject(), file2.getVirtualFile(), 0), false);
            assert (editor != null);
            if (this.myFile != null) {
                FileEditorManager.getInstance((Project)this.getProject()).closeFile(this.myFile.getVirtualFile());
            }
            this.myEditor = editor;
            this.myFile = file2;
        }
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            document.replaceString(0, document.getTextLength(), (CharSequence)text);
            PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
            FormatterTestCase.assertEquals((String)file2.getText(), (String)document.getText());
            try {
                if (this.doReformatRangeTest) {
                    CodeStyleManager.getInstance((Project)this.getProject()).reformatRange((PsiElement)file2, file2.getTextRange().getStartOffset(), file2.getTextRange().getEndOffset());
                } else if (this.myTextRange != null) {
                    CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file2, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
                } else {
                    CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file2, file2.getTextRange().getStartOffset(), file2.getTextRange().getEndOffset());
                }
            }
            catch (IncorrectOperationException e) {
                FormatterTestCase.fail();
            }
        });
        FormatterTestCase.assertEquals((String)textAfter, (String)document.getText());
        PsiDocumentManager.getInstance((Project)this.getProject()).commitDocument(document);
        FormatterTestCase.assertEquals((String)textAfter, (String)file2.getText());
    }

    protected void performFormatting(PsiFile file2) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)this.getProject()).reformat((PsiElement)file2);
            } else {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatRange((PsiElement)file2, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            FormatterTestCase.fail();
        }
    }

    protected void performFormattingWithDocument(PsiFile file2) {
        try {
            if (this.myTextRange == null) {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file2, 0, file2.getTextLength());
            } else {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file2, this.myTextRange.getStartOffset(), this.myTextRange.getEndOffset());
            }
        }
        catch (IncorrectOperationException e) {
            FormatterTestCase.fail();
        }
    }

    protected String loadFile(String name, String resultNumber) throws Exception {
        String fullName = this.getTestDataPath() + File.separatorChar + this.getBasePath() + File.separatorChar + name;
        String text = FileUtil.loadFile((File)new File(fullName));
        text = StringUtil.convertLineSeparators((String)text);
        if (resultNumber == null) {
            return this.prepareText(text);
        }
        String beginLine = "<<<" + resultNumber + ">>>";
        String endLine = "<<</" + resultNumber + ">>>";
        int beginPos = text.indexOf(beginLine);
        FormatterTestCase.assertTrue((beginPos >= 0 ? 1 : 0) != 0);
        int endPos = text.indexOf(endLine);
        FormatterTestCase.assertTrue((endPos >= 0 ? 1 : 0) != 0);
        return this.prepareText(text.substring(beginPos + beginLine.length(), endPos).trim());
    }

    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath();
    }

    protected String prepareText(String text) {
        return text;
    }

    protected abstract String getBasePath();

    protected abstract String getFileExtension();

    protected CommonCodeStyleSettings getSettings(Language language) {
        return CodeStyle.getSettings((Project)this.getProject()).getCommonSettings(language);
    }

    protected CodeStyleSettings getSettings() {
        return CodeStyle.getSettings((Project)this.getProject());
    }

    protected void doSanityTest(boolean formatWithPsi) throws IOException, IncorrectOperationException {
        File sanityDirectory = new File(this.getTestDataPath() + File.separatorChar + this.getBasePath(), "sanity");
        File[] subFiles = sanityDirectory.listFiles();
        ArrayList failedFiles = new ArrayList();
        if (subFiles != null) {
            for (File subFile : subFiles) {
                this.doSanityTestForFile(subFile, failedFiles, formatWithPsi);
            }
            if (!failedFiles.isEmpty()) {
                FormatterTestCase.fail((String)("Failed for files: " + FormatterTestCase.composeMessage(failedFiles)));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSanityTestForFile(File subFile, List<? super File> failedFiles, boolean formatWithPsi) throws IOException, IncorrectOperationException {
        if (subFile.isFile() && subFile.getName().endsWith(this.getFileExtension())) {
            byte[] bytes = FileUtil.loadFileBytes((File)subFile);
            String text = new String(bytes, Charsets.UTF_8);
            String fileName = "before." + this.getFileExtension();
            PsiFile file2 = PsiFileFactory.getInstance((Project)this.getProject()).createFileFromText(fileName, this.getFileType(fileName), (CharSequence)StringUtil.convertLineSeparators((String)text), LocalTimeCounter.currentTime(), true);
            try {
                CommandProcessor.getInstance().executeCommand(this.getProject(), () -> ApplicationManager.getApplication().runWriteAction(() -> {
                    try {
                        if (formatWithPsi) {
                            this.performFormatting(file2);
                        } else {
                            this.performFormattingWithDocument(file2);
                        }
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        failedFiles.add(subFile);
                    }
                    System.out.println(subFile.getPath() + ": finished");
                }), "", null);
            }
            finally {
                VirtualFile virtualFile = file2.getVirtualFile();
                if (virtualFile != null) {
                    ((UndoManagerImpl)UndoManager.getInstance((Project)this.getProject())).clearUndoRedoQueueInTests(virtualFile);
                    ((UndoManagerImpl)UndoManager.getGlobalInstance()).clearUndoRedoQueueInTests(virtualFile);
                }
            }
        }
    }

    private static String composeMessage(List<? extends File> failedFiles) {
        StringBuilder result = new StringBuilder();
        for (File file2 : failedFiles) {
            result.append(file2.getPath());
            result.append("\n");
        }
        return result.toString();
    }
}

