/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi;

import com.intellij.lang.properties.psi.PropertyKeyValueFormat;
import org.jetbrains.annotations.NotNull;

public final class PropertiesResourceBundleUtil {
    private static final char ESCAPE_SYMBOL = '\\';

    @NotNull
    public static String fromPropertyValueToValueEditor(@NotNull String text) {
        StringBuilder buffer = new StringBuilder();
        boolean escaped = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == '\\' && !escaped && (i == text.length() - 1 || text.charAt(i + 1) != 'u' && text.charAt(i + 1) != 'U')) {
                escaped = true;
                continue;
            }
            if (escaped && (c == 'n' || c == 'r')) {
                buffer.append('\\');
            }
            buffer.append(c);
            escaped = false;
        }
        return buffer.toString();
    }

    @NotNull
    public static String convertValueToFileFormat(@NotNull String value, char delimiter, @NotNull PropertyKeyValueFormat valueFormat) {
        if (valueFormat == PropertyKeyValueFormat.FILE) {
            return value;
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\n' || c == '\r') {
                buffer.append('\\');
                if (valueFormat == PropertyKeyValueFormat.MEMORY) {
                    buffer.append(c == '\n' ? (char)'n' : 'r');
                    continue;
                }
                buffer.append(c);
                continue;
            }
            if (i == 0 && (c == ' ' || c == '\t') || delimiter == ' ' && (c == '=' || c == ':')) {
                buffer.append('\\');
                buffer.append(c);
                continue;
            }
            if (c == '\\') {
                if (i + 1 >= value.length() || !PropertiesResourceBundleUtil.isEscapedChar(value.charAt(i + 1)) || valueFormat == PropertyKeyValueFormat.MEMORY) {
                    buffer.append('\\');
                }
                buffer.append(c);
                continue;
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static boolean isEscapedChar(char nextChar) {
        return nextChar == 'n' || nextChar == 'r' || nextChar == 'u' || nextChar == 'U';
    }
}

