/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.WCInfo;

public class MergeContext {
    @NotNull
    private final Project myProject;
    @NotNull
    private final String myBranchName;
    @NotNull
    private final VirtualFile myRoot;
    @NotNull
    private final WCInfo myWcInfo;
    @NotNull
    private final Url mySourceUrl;
    @NotNull
    private final SvnVcs myVcs;
    @NotNull
    private final String myTitle;
    @NotNull
    private final String myRepositoryRelativeSourcePath;
    @NotNull
    private final String myRepositoryRelativeWorkingCopyPath;

    public MergeContext(@NotNull SvnVcs vcs, @NotNull Url sourceUrl, @NotNull WCInfo wcInfo, @NotNull String branchName, @NotNull VirtualFile root) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myBranchName = branchName;
        this.myRoot = root;
        this.mySourceUrl = sourceUrl;
        this.myWcInfo = wcInfo;
        this.myTitle = "Merge from " + this.myBranchName;
        this.myRepositoryRelativeSourcePath = SvnUtil.ensureStartSlash(SvnUtil.getRelativeUrl(this.myWcInfo.getRepoUrl(), this.mySourceUrl));
        this.myRepositoryRelativeWorkingCopyPath = SvnUtil.ensureStartSlash(SvnUtil.getRelativeUrl(this.myWcInfo.getRepoUrl(), this.myWcInfo.getUrl()));
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public String getBranchName() {
        return this.myBranchName;
    }

    @NotNull
    public VirtualFile getRoot() {
        return this.myRoot;
    }

    @NotNull
    public WCInfo getWcInfo() {
        return this.myWcInfo;
    }

    @NotNull
    public Url getSourceUrl() {
        return this.mySourceUrl;
    }

    @NotNull
    public String getRepositoryRelativeSourcePath() {
        return this.myRepositoryRelativeSourcePath;
    }

    @NotNull
    public String getRepositoryRelativeWorkingCopyPath() {
        return this.myRepositoryRelativeWorkingCopyPath;
    }

    @NotNull
    public SvnVcs getVcs() {
        return this.myVcs;
    }

    @NotNull
    public String getTitle() {
        return this.myTitle;
    }
}

