/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.history;

import com.google.common.net.UrlEscapers;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.history.LogEntryConsumer;
import org.jetbrains.idea.svn.history.LogEntryPath;
import org.jetbrains.idea.svn.info.Info;

public class LatestExistentSearcher {
    private static final Logger LOG = Logger.getInstance(LatestExistentSearcher.class);
    private long myStartNumber;
    private boolean myStartExistsKnown;
    @NotNull
    private final Url myUrl;
    @NotNull
    private final Url myRepositoryUrl;
    @NotNull
    private final String myRelativeUrl;
    private final SvnVcs myVcs;
    private long myEndNumber;

    public LatestExistentSearcher(SvnVcs vcs, @NotNull Url url, @NotNull Url repositoryUrl) {
        this(0L, -1L, false, vcs, url, repositoryUrl);
    }

    public LatestExistentSearcher(long startNumber, long endNumber, boolean startExistsKnown, SvnVcs vcs, @NotNull Url url, @NotNull Url repositoryUrl) {
        this.myStartNumber = startNumber;
        this.myEndNumber = endNumber;
        this.myStartExistsKnown = startExistsKnown;
        this.myVcs = vcs;
        this.myUrl = url;
        this.myRepositoryUrl = repositoryUrl;
        this.myRelativeUrl = SvnUtil.ensureStartSlash(UrlEscapers.urlFragmentEscaper().escape(SvnUtil.getRelativeUrl(this.myRepositoryUrl, this.myUrl)));
    }

    public long getDeletionRevision() {
        if (!this.detectStartRevision()) {
            return -1L;
        }
        Ref latest = new Ref((Object)-1L);
        try {
            Url existingParent;
            if (this.myEndNumber == -1L) {
                this.myEndNumber = this.getLatestRevision();
            }
            if ((existingParent = this.getExistingParent(this.myUrl)) == null) {
                return this.myStartNumber;
            }
            Revision startRevision = Revision.of(this.myStartNumber);
            Target target = Target.on(existingParent, startRevision);
            this.myVcs.getFactory(target).createHistoryClient().doLog(target, startRevision, Revision.HEAD, false, true, false, 0L, null, this.createHandler((Ref<Long>)latest));
        }
        catch (VcsException e) {
            LOG.info((Throwable)e);
        }
        return (Long)latest.get();
    }

    @NotNull
    private LogEntryConsumer createHandler(@NotNull Ref<Long> latest) {
        return logEntry -> {
            Map<String, LogEntryPath> changedPaths = logEntry.getChangedPaths();
            for (LogEntryPath o : changedPaths.values()) {
                LogEntryPath path = o;
                if (path.getType() != 'D' || !this.myRelativeUrl.equals(path.getPath())) continue;
                latest.set((Object)logEntry.getRevision());
                throw new SvnBindException("Latest existent revision found for " + this.myRelativeUrl);
            }
        };
    }

    public long getLatestExistent() {
        if (!this.detectStartRevision()) {
            return this.myStartNumber;
        }
        long latestOk = this.myStartNumber;
        try {
            if (this.myEndNumber == -1L) {
                this.myEndNumber = this.getLatestRevision();
            }
            for (long i = this.myStartNumber + 1L; i < this.myEndNumber; ++i) {
                if (!this.existsInRevision(this.myUrl, i)) continue;
                latestOk = i;
            }
        }
        catch (SvnBindException e) {
            LOG.info((Throwable)((Object)e));
        }
        return latestOk;
    }

    private boolean detectStartRevision() {
        if (!this.myStartExistsKnown) {
            SvnFileUrlMapping mapping = this.myVcs.getSvnFileUrlMapping();
            RootUrlInfo rootUrlInfo = mapping.getWcRootForUrl(this.myUrl);
            if (rootUrlInfo == null) {
                return true;
            }
            VirtualFile vf = rootUrlInfo.getVirtualFile();
            Info info2 = this.myVcs.getInfo(vf);
            if (info2 == null || !info2.getRevision().isValid()) {
                return false;
            }
            this.myStartNumber = info2.getRevision().getNumber();
            this.myStartExistsKnown = true;
        }
        return true;
    }

    @Nullable
    private Url getExistingParent(Url url) throws SvnBindException {
        while (url != null && !url.equals(this.myRepositoryUrl) && !this.existsInRevision(url, this.myEndNumber)) {
            url = SvnUtil.removePathTail(url);
        }
        return url;
    }

    private boolean existsInRevision(@NotNull Url url, long revisionNumber) throws SvnBindException {
        Info info2;
        block2: {
            Revision revision = Revision.of(revisionNumber);
            info2 = null;
            try {
                info2 = this.myVcs.getInfo(url, revision, revision);
            }
            catch (SvnBindException e) {
                if (e.contains(ErrorCode.RA_ILLEGAL_URL)) break block2;
                throw e;
            }
        }
        return info2 != null;
    }

    private long getLatestRevision() throws SvnBindException {
        return SvnUtil.getHeadRevision(this.myVcs, this.myRepositoryUrl).getNumber();
    }
}

