/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs;

import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.NestedCopyType;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class WCInfo {
    private final boolean myIsWcRoot;
    @NotNull
    private final Depth myStickyDepth;
    @NotNull
    private final RootUrlInfo myRootInfo;

    public WCInfo(@NotNull RootUrlInfo rootInfo, boolean isWcRoot, @NotNull Depth stickyDepth) {
        this.myRootInfo = rootInfo;
        this.myIsWcRoot = isWcRoot;
        this.myStickyDepth = stickyDepth;
    }

    @NotNull
    public Depth getStickyDepth() {
        return this.myStickyDepth;
    }

    @NotNull
    public String getPath() {
        return this.myRootInfo.getPath();
    }

    @Nullable
    public VirtualFile getVcsRoot() {
        return null;
    }

    @NotNull
    public Url getUrl() {
        return this.myRootInfo.getUrl();
    }

    @NotNull
    public Url getRepoUrl() {
        return this.myRootInfo.getRepositoryUrl();
    }

    @NotNull
    public RootUrlInfo getRootInfo() {
        return this.myRootInfo;
    }

    public boolean hasError() {
        return this.getRootInfo().getNode().hasError();
    }

    @NotNull
    public String getErrorMessage() {
        SvnBindException error = this.getRootInfo().getNode().getError();
        return error != null ? error.getMessage() : "";
    }

    @NotNull
    public WorkingCopyFormat getFormat() {
        return this.myRootInfo.getFormat();
    }

    public boolean isIsWcRoot() {
        return this.myIsWcRoot;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WCInfo)) {
            return false;
        }
        WCInfo wcInfo = (WCInfo)o;
        return this.getPath().equals(wcInfo.getPath());
    }

    public int hashCode() {
        return this.getPath().hashCode();
    }

    @Nullable
    public NestedCopyType getType() {
        return this.myRootInfo.getType();
    }
}

