/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.delete;

import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.checkin.CmdCheckinClient;
import org.jetbrains.idea.svn.commandLine.BaseUpdateCommandListener;
import org.jetbrains.idea.svn.commandLine.CommandUtil;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;
import org.jetbrains.idea.svn.delete.DeleteClient;

public class CmdDeleteClient
extends BaseSvnClient
implements DeleteClient {
    @Override
    public void delete(@NotNull File path, boolean force, boolean dryRun, @Nullable ProgressTracker handler) throws VcsException {
        if (!dryRun) {
            ArrayList<String> parameters = new ArrayList<String>();
            CommandUtil.put(parameters, path);
            CommandUtil.put(parameters, force, "--force");
            File workingDirectory = CommandUtil.getHomeDirectory();
            BaseUpdateCommandListener listener2 = new BaseUpdateCommandListener(workingDirectory, handler);
            this.execute(this.myVcs, Target.on(path), workingDirectory, SvnCommandName.delete, parameters, listener2);
            listener2.throwWrappedIfException();
        }
    }

    @Override
    public long delete(@NotNull Url url, @NotNull String message) throws VcsException {
        Target target = Target.on(url);
        ArrayList<String> parameters = new ArrayList<String>();
        CommandUtil.put(parameters, target);
        parameters.add("--message");
        parameters.add(message);
        CmdCheckinClient.CommandListener listener2 = new CmdCheckinClient.CommandListener(null);
        this.execute(this.myVcs, target, SvnCommandName.delete, parameters, (LineCommandListener)listener2);
        return listener2.getCommittedRevision();
    }
}

