/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.api.ErrorCategory;
import org.jetbrains.idea.svn.api.ErrorCode;

public class SvnBindException
extends VcsException {
    public static final String ERROR_MESSAGE_FORMAT = "svn: E%d: %s";
    @NotNull
    private final MultiMap<Integer, String> errors = MultiMap.create();
    @NotNull
    private final MultiMap<Integer, String> warnings = MultiMap.create();

    public SvnBindException(@NotNull ErrorCode code, @NotNull String message) {
        super(String.format(ERROR_MESSAGE_FORMAT, code.getCode(), message));
        this.errors.putValue((Object)code.getCode(), (Object)this.getMessage());
    }

    public SvnBindException(@Nullable String message) {
        this(message, null);
    }

    public SvnBindException(@Nullable Throwable cause) {
        this(null, cause);
    }

    public SvnBindException(@Nullable String message, @Nullable Throwable cause) {
        super((String)ObjectUtils.chooseNotNull((Object)message, (Object)SvnBindException.getMessage((Throwable)cause)), cause);
        this.init(message);
    }

    private void init(@Nullable String message) {
        if (!StringUtil.isEmpty((String)message)) {
            SvnBindException.parse(message, SvnUtil.ERROR_PATTERN, this.errors);
            SvnBindException.parse(message, SvnUtil.WARNING_PATTERN, this.warnings);
        }
    }

    public boolean contains(int code) {
        return this.errors.containsKey((Object)code) || this.warnings.containsKey((Object)code);
    }

    public boolean contains(@NotNull ErrorCode code) {
        return this.contains(code.getCode());
    }

    public boolean containsCategory(ErrorCategory category) {
        Condition belongsToCategoryCondition = errorCode -> ErrorCategory.categoryCodeOf(errorCode) == category.getCode();
        return ContainerUtil.exists((Iterable)this.errors.keySet(), (Condition)belongsToCategoryCondition) || ContainerUtil.exists((Iterable)this.warnings.keySet(), (Condition)belongsToCategoryCondition);
    }

    private static void parse(@NotNull String message, @NotNull Pattern pattern, @NotNull MultiMap<Integer, String> map) {
        Matcher matcher = pattern.matcher(message);
        while (matcher.find()) {
            map.putValue((Object)Integer.valueOf(matcher.group(2)), (Object)matcher.group());
        }
    }
}

