/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.commandLine;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.AuthCallbackCase;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class CertificateCallbackCase
extends AuthCallbackCase {
    private static final String CERTIFICATE_ERROR = "Error validating server certificate for";
    private static final String UNTRUSTED_SERVER_CERTIFICATE = "Server SSL certificate untrusted";
    private static final String CERTIFICATE_VERIFICATION_FAILED = "certificate verification failed";
    private static final String CERTIFICATE_VERIFICATION_FAILED_ISSUER_NOT_TRUSTED = "certificate verification failed: issuer is not trusted";
    private boolean accepted;

    CertificateCallbackCase(@NotNull AuthenticationService authenticationService, Url url) {
        super(authenticationService, url);
    }

    @Override
    public boolean canHandle(String error) {
        return error.startsWith(CERTIFICATE_ERROR) || error.contains(UNTRUSTED_SERVER_CERTIFICATE) || CertificateCallbackCase.isValidButUntrustedCertificate(error);
    }

    @Override
    public boolean getCredentials(String errText) throws SvnBindException {
        if (this.myAuthenticationService.acceptSSLServerCertificate(this.myUrl)) {
            this.accepted = true;
            return true;
        }
        throw new SvnBindException("Server SSL certificate rejected");
    }

    @Override
    public void updateParameters(@NotNull Command command) {
        if (this.accepted) {
            command.put("--trust-server-cert");
            command.put("--non-interactive");
        }
    }

    public static boolean isValidButUntrustedCertificate(@NotNull String error) {
        return error.contains(CERTIFICATE_VERIFICATION_FAILED_ISSUER_NOT_TRUSTED);
    }

    public static boolean isCertificateVerificationFailed(@NotNull String error) {
        return error.contains(CERTIFICATE_VERIFICATION_FAILED);
    }
}

