/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.branchConfig.BranchConfigurationDialog;
import org.jetbrains.idea.svn.history.SvnChangeList;

public class ConfigureBranchesAction
extends DumbAwareAction {
    public ConfigureBranchesAction() {
        super(SvnBundle.message("configure.branches.item", new Object[0]), SvnBundle.message("configure.branches.item", new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        Presentation presentation = e.getPresentation();
        if (project == null) {
            presentation.setEnabledAndVisible(false);
            return;
        }
        presentation.setVisible(true);
        Object[] changeLists = (ChangeList[])e.getData(VcsDataKeys.CHANGE_LISTS);
        presentation.setEnabled(!ArrayUtil.isEmpty((Object[])changeLists) && SvnVcs.getInstance(project).getName().equals(((CommittedChangeList)changeLists[0]).getVcs().getName()) && ((SvnChangeList)changeLists[0]).getRoot() != null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ChangeList[] changeLists = (ChangeList[])e.getRequiredData(VcsDataKeys.CHANGE_LISTS);
        SvnChangeList svnList = (SvnChangeList)changeLists[0];
        BranchConfigurationDialog.configureBranches(project, svnList.getRoot());
    }
}

