/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.WorkingCopyFormat;
import org.jetbrains.idea.svn.api.ClientFactory;
import org.jetbrains.idea.svn.api.EventAction;
import org.jetbrains.idea.svn.api.ProgressEvent;
import org.jetbrains.idea.svn.api.ProgressTracker;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.api.SvnClient;
import org.jetbrains.idea.svn.api.Target;
import org.jetbrains.idea.svn.auth.AuthenticationService;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.CommandExecutor;
import org.jetbrains.idea.svn.commandLine.CommandRuntime;
import org.jetbrains.idea.svn.commandLine.LineCommandListener;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public abstract class BaseSvnClient
implements SvnClient {
    protected SvnVcs myVcs;
    protected ClientFactory myFactory;
    protected boolean myIsActive;

    @Override
    @NotNull
    public SvnVcs getVcs() {
        return this.myVcs;
    }

    @Override
    public void setVcs(@NotNull SvnVcs vcs) {
        this.myVcs = vcs;
    }

    @Override
    @NotNull
    public ClientFactory getFactory() {
        return this.myFactory;
    }

    @Override
    public void setFactory(@NotNull ClientFactory factory) {
        this.myFactory = factory;
    }

    @Override
    public void setIsActive(boolean isActive) {
        this.myIsActive = isActive;
    }

    protected void assertUrl(@NotNull Target target) {
        if (!target.isUrl()) {
            throw new IllegalArgumentException("Target should be url " + target);
        }
    }

    protected void assertFile(@NotNull Target target) {
        if (!target.isFile()) {
            throw new IllegalArgumentException("Target should be file " + target);
        }
    }

    protected void assertDirectory(@NotNull Target target) {
        this.assertFile(target);
        if (!target.getFile().isDirectory()) {
            throw new IllegalArgumentException("Target should be directory " + target);
        }
    }

    protected void validateFormat(@NotNull WorkingCopyFormat format, @NotNull Collection<WorkingCopyFormat> supported) throws VcsException {
        if (!supported.contains((Object)format)) {
            throw new VcsException(String.format("%s format is not supported. Supported formats are: %s.", format.getName(), StringUtil.join(supported, (String)",")));
        }
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull Target target, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener2) throws SvnBindException {
        return this.execute(vcs, target, null, name, parameters, listener2);
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable File workingDirectory, @NotNull SvnCommandName name, @NotNull List<String> parameters, @Nullable LineCommandListener listener2) throws SvnBindException {
        Command command = this.newCommand(name);
        command.put(parameters);
        return this.execute(vcs, target, workingDirectory, command, listener2);
    }

    @NotNull
    public CommandExecutor execute(@NotNull SvnVcs vcs, @NotNull Target target, @Nullable File workingDirectory, @NotNull Command command, @Nullable LineCommandListener listener2) throws SvnBindException {
        command.setTarget(target);
        command.setWorkingDirectory(workingDirectory);
        command.setResultBuilder(listener2);
        return this.newRuntime(vcs).runWithAuthenticationAttempt(command);
    }

    @NotNull
    public Command newCommand(@NotNull SvnCommandName name) {
        return new Command(name);
    }

    @NotNull
    public CommandRuntime newRuntime(@NotNull SvnVcs vcs) {
        return new CommandRuntime(vcs, new AuthenticationService(vcs, this.myIsActive));
    }

    public static void callHandler(@Nullable ProgressTracker handler, @NotNull ProgressEvent event) throws SvnBindException {
        if (handler != null) {
            handler.consume(event);
        }
    }

    @NotNull
    protected static ProgressEvent createEvent(@NotNull File path, @Nullable EventAction action) {
        return new ProgressEvent(path, 0L, null, null, action, null, null);
    }

    @NotNull
    protected static Revision notNullize(@Nullable Revision revision) {
        return revision != null ? revision : Revision.UNDEFINED;
    }
}

