/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.annotate;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationSource;
import com.intellij.openapi.vcs.annotate.AnnotationSourceSwitcher;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspect;
import com.intellij.openapi.vcs.annotate.LineAnnotationAspectAdapter;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.annotate.AnnotationTooltipBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnRevisionNumber;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Revision;
import org.jetbrains.idea.svn.checkin.CommitInfo;
import org.jetbrains.idea.svn.history.SvnFileRevision;

public abstract class BaseSvnFileAnnotation
extends FileAnnotation {
    private final String myContents;
    protected final VcsRevisionNumber myBaseRevision;
    private final MyPartiallyCreatedInfos myInfos;
    protected final SvnVcs myVcs;
    private final Long2ObjectMap<SvnFileRevision> myRevisionMap = new Long2ObjectOpenHashMap();
    private final LineAnnotationAspect DATE_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.DATE, true){

        @Override
        public String getValue(@NotNull CommitInfo info2) {
            return FileAnnotation.formatDate((Date)info2.getDate());
        }
    };
    private final LineAnnotationAspect REVISION_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.REVISION, false){

        @Override
        public String getValue(@NotNull CommitInfo info2) {
            return String.valueOf(info2.getRevisionNumber());
        }
    };
    private final LineAnnotationAspect ORIGINAL_REVISION_ASPECT = new SvnAnnotationAspect(SvnBundle.message("annotation.original.revision", new Object[0]), false){

        @Override
        public String getValue(int lineNumber) {
            long value = BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNumber);
            return value == -1L ? "" : String.valueOf(value);
        }

        @Override
        protected long getRevision(int lineNum) {
            return BaseSvnFileAnnotation.this.myInfos.originalRevision(lineNum);
        }

        public String getTooltipText(int lineNumber) {
            if (!BaseSvnFileAnnotation.this.myInfos.isValid(lineNumber)) {
                return "";
            }
            CommitInfo info2 = BaseSvnFileAnnotation.this.myInfos.get(lineNumber);
            if (info2 == null) {
                return null;
            }
            SvnFileRevision revision = (SvnFileRevision)BaseSvnFileAnnotation.this.myRevisionMap.get(info2.getRevisionNumber());
            return revision != null ? XmlStringUtil.escapeString((String)("Revision " + info2.getRevisionNumber() + ": " + revision.getCommitMessage())) : "";
        }
    };
    private final LineAnnotationAspect AUTHOR_ASPECT = new SvnAnnotationAspect(LineAnnotationAspect.AUTHOR, true){

        @Override
        public String getValue(@NotNull CommitInfo info2) {
            return info2.getAuthor();
        }
    };
    private final SvnConfiguration myConfiguration;
    private final boolean myShowMergeSources;
    private SvnRevisionNumber myFirstRevisionNumber;

    public void setRevision(long revision, SvnFileRevision svnRevision) {
        this.myRevisionMap.put(revision, (Object)svnRevision);
    }

    public SvnFileRevision getRevision(long revision) {
        return (SvnFileRevision)this.myRevisionMap.get(revision);
    }

    public void setFirstRevision(Revision revision) {
        this.myFirstRevisionNumber = new SvnRevisionNumber(revision);
    }

    public SvnRevisionNumber getFirstRevisionNumber() {
        return this.myFirstRevisionNumber;
    }

    public BaseSvnFileAnnotation(@NotNull SvnVcs vcs, String contents, VcsRevisionNumber baseRevision) {
        super(vcs.getProject());
        this.myVcs = vcs;
        this.myContents = contents;
        this.myBaseRevision = baseRevision;
        this.myConfiguration = vcs.getSvnConfiguration();
        this.myShowMergeSources = this.myConfiguration.isShowMergeSourcesInAnnotate();
        this.myInfos = new MyPartiallyCreatedInfos();
    }

    public LineAnnotationAspect @NotNull [] getAspects() {
        return new LineAnnotationAspect[]{this.REVISION_ASPECT, this.DATE_ASPECT, this.AUTHOR_ASPECT};
    }

    @Nullable
    public String getToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, false);
    }

    @Nullable
    public String getHtmlToolTip(int lineNumber) {
        return this.getToolTip(lineNumber, true);
    }

    @Nullable
    private String getToolTip(int lineNumber, boolean asHtml) {
        CommitInfo info2 = this.myInfos.getOrNull(lineNumber);
        if (info2 == null) {
            return null;
        }
        SvnFileRevision revision = (SvnFileRevision)this.myRevisionMap.get(info2.getRevisionNumber());
        if (revision == null) {
            return null;
        }
        String prefix = this.myInfos.getAnnotationSource(lineNumber).showMerged() ? "Merge source revision" : "Revision";
        return AnnotationTooltipBuilder.buildSimpleTooltip((Project)this.getProject(), (boolean)asHtml, (String)prefix, (String)String.valueOf(info2.getRevisionNumber()), (String)revision.getCommitMessage());
    }

    public String getAnnotatedContent() {
        return this.myContents;
    }

    public void setLineInfo(int lineNumber, @NotNull CommitInfo info2, @Nullable CommitInfo mergeInfo) {
        this.myInfos.appendNumberedLineInfo(lineNumber, info2, mergeInfo);
    }

    @Nullable
    public VcsRevisionNumber originalRevision(int lineNumber) {
        SvnFileRevision revision = this.myInfos.isValid(lineNumber) ? (SvnFileRevision)this.myRevisionMap.get(this.myInfos.originalRevision(lineNumber)) : null;
        return revision != null ? revision.getRevisionNumber() : null;
    }

    public VcsRevisionNumber getLineRevisionNumber(int lineNumber) {
        CommitInfo info2 = this.myInfos.getOrNull(lineNumber);
        return info2 != null && info2.getRevisionNumber() >= 0L ? new SvnRevisionNumber(Revision.of(info2.getRevisionNumber())) : null;
    }

    public Date getLineDate(int lineNumber) {
        CommitInfo info2 = this.myInfos.getOrNull(lineNumber);
        return info2 != null ? info2.getDate() : null;
    }

    public List<VcsFileRevision> getRevisions() {
        ArrayList<VcsFileRevision> result = new ArrayList<VcsFileRevision>((Collection<VcsFileRevision>)this.myRevisionMap.values());
        result.sort((o1, o2) -> o2.getRevisionNumber().compareTo((Object)o1.getRevisionNumber()));
        return result;
    }

    @Nullable
    public AnnotationSourceSwitcher getAnnotationSourceSwitcher() {
        if (!this.myShowMergeSources) {
            return null;
        }
        return new AnnotationSourceSwitcher(){

            @NotNull
            public AnnotationSource getAnnotationSource(int lineNumber) {
                return BaseSvnFileAnnotation.this.myInfos.getAnnotationSource(lineNumber);
            }

            public boolean mergeSourceAvailable(int lineNumber) {
                return BaseSvnFileAnnotation.this.myInfos.mergeSourceAvailable(lineNumber);
            }

            @NotNull
            public LineAnnotationAspect getRevisionAspect() {
                return BaseSvnFileAnnotation.this.ORIGINAL_REVISION_ASPECT;
            }

            @NotNull
            public AnnotationSource getDefaultSource() {
                return AnnotationSource.getInstance((boolean)BaseSvnFileAnnotation.this.myShowMergeSources);
            }

            public void switchTo(AnnotationSource source) {
                BaseSvnFileAnnotation.this.myInfos.setShowMergeSource(source.showMerged());
            }
        };
    }

    public int getLineCount() {
        return this.myInfos.size();
    }

    public VcsKey getVcsKey() {
        return SvnVcs.getKey();
    }

    protected abstract void showAllAffectedPaths(SvnRevisionNumber var1);

    @Nullable
    public VcsRevisionNumber getCurrentRevision() {
        return this.myBaseRevision;
    }

    private static final class MyPartiallyCreatedInfos {
        private boolean myShowMergeSource;
        private final Int2ObjectMap<CommitInfo> myMappedLineInfo;
        private final Int2ObjectMap<CommitInfo> myMergeSourceInfos = new Int2ObjectOpenHashMap();
        private int myMaxIdx = 0;

        private MyPartiallyCreatedInfos() {
            this.myMappedLineInfo = new Int2ObjectOpenHashMap();
        }

        void setShowMergeSource(boolean showMergeSource) {
            this.myShowMergeSource = showMergeSource;
        }

        int size() {
            return this.myMaxIdx + 1;
        }

        void appendNumberedLineInfo(int lineNumber, @NotNull CommitInfo info2, @Nullable CommitInfo mergeInfo) {
            if (this.myMappedLineInfo.get(lineNumber) != null) {
                return;
            }
            this.myMaxIdx = Math.max(this.myMaxIdx, lineNumber);
            this.myMappedLineInfo.put(lineNumber, (Object)info2);
            if (mergeInfo != null) {
                this.myMergeSourceInfos.put(lineNumber, (Object)mergeInfo);
            }
        }

        CommitInfo get(int idx) {
            CommitInfo lineInfo;
            if (this.myShowMergeSource && (lineInfo = (CommitInfo)this.myMergeSourceInfos.get(idx)) != null) {
                return lineInfo;
            }
            return (CommitInfo)this.myMappedLineInfo.get(idx);
        }

        @Nullable
        CommitInfo getOrNull(int lineNumber) {
            return this.isValid(lineNumber) ? this.get(lineNumber) : null;
        }

        private boolean isValid(int lineNumber) {
            return lineNumber >= 0 && lineNumber < this.size();
        }

        AnnotationSource getAnnotationSource(int line) {
            return this.myShowMergeSource ? AnnotationSource.getInstance((boolean)this.myMergeSourceInfos.containsKey(line)) : AnnotationSource.LOCAL;
        }

        public long originalRevision(int line) {
            CommitInfo info2 = line < this.size() ? (CommitInfo)this.myMappedLineInfo.get(line) : null;
            return info2 == null ? -1L : info2.getRevisionNumber();
        }

        public boolean mergeSourceAvailable(int lineNumber) {
            return this.myMergeSourceInfos.containsKey(lineNumber);
        }
    }

    private abstract class SvnAnnotationAspect
    extends LineAnnotationAspectAdapter {
        SvnAnnotationAspect(String id, boolean showByDefault) {
            super(id, showByDefault);
        }

        protected long getRevision(int lineNum) {
            CommitInfo lineInfo = BaseSvnFileAnnotation.this.myInfos.get(lineNum);
            return lineInfo == null ? -1L : lineInfo.getRevisionNumber();
        }

        protected void showAffectedPaths(int lineNum) {
            long revision;
            if (BaseSvnFileAnnotation.this.myInfos.isValid(lineNum) && (revision = this.getRevision(lineNum)) >= 0L) {
                BaseSvnFileAnnotation.this.showAllAffectedPaths(new SvnRevisionNumber(Revision.of(revision)));
            }
        }

        public String getValue(int lineNumber) {
            CommitInfo info2 = BaseSvnFileAnnotation.this.myInfos.getOrNull(lineNumber);
            return info2 == null ? "" : this.getValue(info2);
        }

        public String getValue(@NotNull CommitInfo info2) {
            return "";
        }
    }
}

