/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.api.Depth;

public class SvnExcludingIgnoredOperation {
    private final Operation myImportAction;
    private final Depth myDepth;
    private final Filter myFilter;

    public SvnExcludingIgnoredOperation(Project project, Operation importAction, Depth depth) {
        this.myImportAction = importAction;
        this.myDepth = depth;
        this.myFilter = new Filter(project);
    }

    private boolean operation(VirtualFile file) throws VcsException {
        if (!this.myFilter.accept(file)) {
            return false;
        }
        this.myImportAction.doOperation(file);
        return true;
    }

    private void executeDown(VirtualFile file) throws VcsException {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                try {
                    return SvnExcludingIgnoredOperation.this.operation(file);
                }
                catch (VcsException e) {
                    throw new VirtualFileVisitor.VisitorException((Throwable)e);
                }
            }
        }, VcsException.class);
    }

    public void execute(VirtualFile file) throws VcsException {
        if (Depth.INFINITY.equals((Object)this.myDepth)) {
            this.executeDown(file);
            return;
        }
        if (!this.operation(file)) {
            return;
        }
        if (Depth.EMPTY.equals((Object)this.myDepth)) {
            return;
        }
        for (VirtualFile child : file.getChildren()) {
            if (Depth.FILES.equals((Object)this.myDepth) && child.isDirectory()) continue;
            this.operation(child);
        }
    }

    public static interface Operation {
        public void doOperation(VirtualFile var1) throws VcsException;
    }

    public static class Filter {
        private final Project myProject;
        private final ProjectLevelVcsManager myVcsManager;
        private final ChangeListManager myClManager;

        public Filter(Project project) {
            this.myProject = project;
            if (!project.isDefault()) {
                this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                this.myClManager = ChangeListManager.getInstance((Project)project);
            } else {
                this.myVcsManager = null;
                this.myClManager = null;
            }
        }

        public boolean accept(VirtualFile file) {
            return this.myProject.isDefault() || !this.isIgnoredByVcs(file) && !this.myClManager.isIgnoredFile(file);
        }

        private boolean isIgnoredByVcs(VirtualFile file) {
            return (Boolean)ReadAction.compute(() -> this.myVcsManager.isIgnored(file));
        }
    }
}

