/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.actions.BasicAction;
import org.jetbrains.idea.svn.ignore.IgnoreInfoGetter;
import org.jetbrains.idea.svn.ignore.SvnPropertyService;

public class AddToIgnoreListAction
extends BasicAction {
    private String myActionName;
    private final boolean myUseCommonExtension;
    @NotNull
    private final IgnoreInfoGetter myInfoGetter;

    public AddToIgnoreListAction(@NotNull IgnoreInfoGetter infoGetter, boolean useCommonExtension) {
        this.myInfoGetter = infoGetter;
        this.myUseCommonExtension = useCommonExtension;
    }

    public void setActionText(String name) {
        this.myActionName = name;
    }

    @Override
    @NotNull
    protected String getActionName() {
        return SvnBundle.message("action.name.ignore.files", new Object[0]);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        presentation.setEnabledAndVisible(true);
        presentation.setText(this.myActionName, false);
        presentation.setDescription(SvnBundle.message(this.myUseCommonExtension ? "action.Subversion.Ignore.MatchExtension.description" : "action.Subversion.Ignore.ExactMatch.description", this.myActionName));
    }

    @Override
    protected void doVcsRefresh(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        VcsDirtyScopeManager vcsDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)vcs.getProject());
        if (file.getParent() != null) {
            vcsDirtyScopeManager.fileDirty(file.getParent());
        }
    }

    @Override
    protected boolean isEnabled(@NotNull SvnVcs vcs, @NotNull VirtualFile file) {
        return true;
    }

    @Override
    protected void perform(@NotNull SvnVcs vcs, @NotNull VirtualFile file, @NotNull DataContext context) {
    }

    @Override
    protected void batchPerform(@NotNull SvnVcs vcs, VirtualFile @NotNull [] files, @NotNull DataContext context) throws VcsException {
        SvnPropertyService.doAddToIgnoreProperty(vcs, this.myUseCommonExtension, files, this.myInfoGetter);
    }

    @Override
    protected boolean isBatchAction() {
        return true;
    }
}

