/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.idea.RareLogger;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.apache.log4j.Level;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.api.ErrorCode;
import org.jetbrains.idea.svn.commandLine.SvnBindException;

public class SvnExceptionLogFilter
implements RareLogger.LogFilter {
    private static final int ourLogUsualInterval = 20000;
    private static final int ourLogRareInterval = 30000;
    private static final Set<ErrorCode> ourLogRarelyCodes = ContainerUtil.newHashSet((Object[])new ErrorCode[]{ErrorCode.WC_UNSUPPORTED_FORMAT, ErrorCode.WC_CORRUPT, ErrorCode.WC_CORRUPT_TEXT_BASE, ErrorCode.WC_NOT_FILE, ErrorCode.WC_NOT_WORKING_COPY, ErrorCode.WC_PATH_NOT_FOUND});

    public Object getKey(@NotNull Level level, @NonNls String message, @Nullable Throwable t, String ... details) {
        SvnBindException e = (SvnBindException)((Object)ObjectUtils.tryCast((Object)t, SvnBindException.class));
        return e != null ? ContainerUtil.find(ourLogRarelyCodes, e::contains) : null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public Integer getAllowedLoggingInterval(Level level, String message, Throwable t, String[] details) {
        int n;
        SvnBindException e = (SvnBindException)((Object)ObjectUtils.tryCast((Object)t, SvnBindException.class));
        if (e != null) {
            if (ContainerUtil.exists(ourLogRarelyCodes, e::contains)) {
                n = 30000;
                return n;
            }
        }
        n = 20000;
        return n;
    }
}

