/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequestProcessor;
import org.apache.xmlrpc.XmlRpcResponseProcessor;
import org.apache.xmlrpc.XmlRpcServerRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;
import org.xml.sax.SAXParseException;

public class XmlRpcServerImpl
implements XmlRpcServer {
    private static final Logger LOG = Logger.getInstance(XmlRpcServerImpl.class);
    private final Map<String, Object> handlerMapping = new ConcurrentHashMap<String, Object>();

    public boolean hasHandler(String name) {
        return this.handlerMapping.containsKey(name);
    }

    public void addHandler(String name, Object handler2) {
        this.handlerMapping.put(name, handler2);
    }

    public void removeHandler(String name) {
        this.handlerMapping.remove(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean process(@NotNull String path, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context, @Nullable Map<String, Object> handlers) {
        ByteBuf result2;
        if (!(path.isEmpty() || path.length() == 1 && path.charAt(0) == '/' || path.equalsIgnoreCase("/rpc2"))) {
            return false;
        }
        if (request2.method() != HttpMethod.POST) {
            return false;
        }
        ByteBuf content2 = request2.content();
        if (content2.readableBytes() == 0) {
            Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (Channel)context.channel(), (HttpRequest)request2);
            return true;
        }
        try (ByteBufInputStream in = new ByteBufInputStream(content2);){
            XmlRpcServerRequest xmlRpcServerRequest = new XmlRpcRequestProcessor().decodeRequest((InputStream)in);
            if (StringUtil.isEmpty((String)xmlRpcServerRequest.getMethodName())) {
                LOG.warn("method name empty");
                boolean bl = false;
                return bl;
            }
            Object response = XmlRpcServerImpl.invokeHandler(XmlRpcServerImpl.getHandler(xmlRpcServerRequest.getMethodName(), handlers == null ? this.handlerMapping : handlers), xmlRpcServerRequest);
            result2 = Unpooled.wrappedBuffer((byte[])new XmlRpcResponseProcessor().encodeResponse(response, "UTF-8"));
        }
        catch (SAXParseException e) {
            LOG.warn((Throwable)e);
            Responses.send((HttpResponseStatus)HttpResponseStatus.BAD_REQUEST, (Channel)context.channel(), (HttpRequest)request2);
            return true;
        }
        catch (Throwable e) {
            context.channel().close();
            LOG.error(e);
            return true;
        }
        Responses.send((HttpResponse)Responses.response((String)"text/xml", (ByteBuf)result2), (Channel)context.channel(), (HttpRequest)request2);
        return true;
    }

    private static Object getHandler(@NotNull String methodName, @NotNull Map<String, Object> handlers) {
        Object handler2 = null;
        String handlerName = null;
        int dot = methodName.lastIndexOf(46);
        if (dot > -1) {
            handlerName = methodName.substring(0, dot);
            handler2 = handlers.get(handlerName);
        }
        if (handler2 != null) {
            return handler2;
        }
        if (dot > -1) {
            throw new IllegalStateException("RPC handler object \"" + handlerName + "\" not found");
        }
        throw new IllegalStateException("RPC handler object not found for \"" + methodName);
    }

    private static Object invokeHandler(@NotNull Object handler2, XmlRpcServerRequest request2) throws Throwable {
        return handler2 instanceof XmlRpcHandler ? (XmlRpcHandler)handler2 : XmlRpcServerImpl.invoke(handler2, request2.getMethodName(), request2.getParameters());
    }

    private static Object invoke(Object target2, String methodName, Vector params) throws Throwable {
        Method method2;
        int dot;
        Class<?> targetClass = target2 instanceof Class ? (Class<?>)target2 : target2.getClass();
        Class[] argClasses = null;
        Object[] argValues = null;
        if (params != null) {
            argClasses = new Class[params.size()];
            argValues = new Object[params.size()];
            for (int i2 = 0; i2 < params.size(); ++i2) {
                argValues[i2] = params.elementAt(i2);
                argClasses[i2] = argValues[i2] instanceof Integer ? Integer.TYPE : (argValues[i2] instanceof Double ? Double.TYPE : (argValues[i2] instanceof Boolean ? Boolean.TYPE : argValues[i2].getClass()));
            }
        }
        if ((dot = methodName.lastIndexOf(46)) > -1 && dot + 1 < methodName.length()) {
            methodName = methodName.substring(dot + 1);
        }
        if ((method2 = targetClass.getMethod(methodName, argClasses)).getDeclaringClass() == Object.class) {
            throw new XmlRpcException(0, "Invoker can't call methods defined in java.lang.Object");
        }
        Object returnValue = method2.invoke(target2, argValues);
        if (returnValue == null && method2.getReturnType() == Void.TYPE) {
            throw new IllegalArgumentException("void return types for handler methods not supported, " + methodName);
        }
        return returnValue;
    }

    static final class XmlRpcRequestHandler
    extends HttpRequestHandler {
        XmlRpcRequestHandler() {
        }

        public boolean isSupported(@NotNull FullHttpRequest request2) {
            return request2.method() == HttpMethod.POST || request2.method() == HttpMethod.OPTIONS;
        }

        public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest request2, @NotNull ChannelHandlerContext context) throws IOException {
            return XmlRpcServer.SERVICE.getInstance().process(urlDecoder.path(), request2, context, null);
        }
    }
}

