/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

public class VariableImpl
implements Variable {
    protected volatile Value value;
    private final String name;
    private final ValueModifier valueModifier;
    private Boolean valueForced = false;

    public VariableImpl(@NotNull String name, @Nullable Value value2, @Nullable ValueModifier valueModifier) {
        this.name = name;
        this.value = value2;
        this.valueModifier = valueModifier;
    }

    public VariableImpl(@NotNull String name, @NotNull Value value2) {
        this(name, value2, null);
    }

    @Override
    @Nullable
    public final ValueModifier getValueModifier() {
        return this.valueModifier;
    }

    @Override
    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public final Value getValue() {
        return this.value;
    }

    @Override
    public void setValue(Value value2) {
        if (!this.valueForced.booleanValue()) {
            this.value = value2;
        }
    }

    public void forceValue(Value value2) {
        this.valueForced = true;
        this.value = value2;
    }

    @Override
    public boolean isMutable() {
        return this.valueModifier != null;
    }

    @Override
    public boolean isReadable() {
        return true;
    }

    public String toString() {
        return "[Variable: name=" + this.getName() + ", value=" + this.getValue() + ']';
    }
}

