/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.URLUtil;
import java.net.URISyntaxException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0010\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u0004J\u0010\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/debugger/ScriptDebuggerUrls;", "", "()V", "newLocalFileUrl", "Lcom/intellij/util/Url;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "", "parse", "url", "asLocalIfNoScheme", "", "toFilePath", "toUri", "absoluteOrRelativePath", "toUriPath", "intellij.platform.scriptDebugger.backend"})
public final class ScriptDebuggerUrls {
    public static final ScriptDebuggerUrls INSTANCE;

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull String path) {
        String uriPath = INSTANCE.toUriPath(path);
        CharSequence charSequence = uriPath;
        boolean bl = false;
        if (charSequence.length() > 0 && uriPath.charAt(0) != '/') {
            throw (Throwable)new URISyntaxException(path, "Must be absolute");
        }
        return Urls.newUrl((String)"file", (String)"", (String)uriPath);
    }

    @Nullable
    public final String toFilePath(@NotNull Url url) {
        if (url.getScheme() != null && Intrinsics.areEqual((Object)url.getScheme(), (Object)"file") ^ true) {
            return null;
        }
        String path = url.getPath();
        if (path.length() >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':') {
            String string = path;
            int n = 1;
            boolean bl = false;
            String string2 = string;
            if (string2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            path = string3;
        }
        return path;
    }

    private final String toUriPath(String path) {
        String result2 = FileUtilRt.toSystemIndependentName((String)path);
        if (result2.length() >= 2 && result2.charAt(1) == ':') {
            result2 = '/' + result2;
        }
        return result2;
    }

    private final Url toUri(String absoluteOrRelativePath) {
        String result2 = FileUtilRt.toSystemIndependentName((String)absoluteOrRelativePath);
        if (result2.length() >= 2 && result2.charAt(1) == ':') {
            result2 = '/' + result2;
        }
        CharSequence charSequence = result2;
        boolean bl = false;
        return charSequence.length() > 0 && result2.charAt(0) == '/' ? ScriptDebuggerUrls.newLocalFileUrl(result2) : Urls.newUnparsable((String)result2);
    }

    @JvmStatic
    @NotNull
    public static final Url newLocalFileUrl(@NotNull VirtualFile file2) {
        return ScriptDebuggerUrls.newLocalFileUrl(file2.getPath());
    }

    @JvmStatic
    @Nullable
    public static final Url parse(@NotNull String url, boolean asLocalIfNoScheme) {
        return asLocalIfNoScheme && !URLUtil.containsScheme((String)url) ? INSTANCE.toUri(url) : Urls.parse((String)url, (boolean)false);
    }

    private ScriptDebuggerUrls() {
    }

    static {
        ScriptDebuggerUrls scriptDebuggerUrls;
        INSTANCE = scriptDebuggerUrls = new ScriptDebuggerUrls();
    }
}

