/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpCharRange;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RepeatedSpaceInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RepeatedSpaceVisitor(holder);
    }

    private static class RepeatedSpaceFix
    implements LocalQuickFix {
        private final int myCount;

        RepeatedSpaceFix(int count) {
            this.myCount = count;
        }

        @Nls
        @NotNull
        public String getName() {
            return CommonQuickFixBundle.message((String)"fix.replace.with.x", (Object[])new Object[]{" {" + this.myCount + "}"});
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return RegExpBundle.message("inspection.quick.fix.replace.with.space.and.repeated.quantifier", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2 = descriptor2.getPsiElement();
            if (!(element2 instanceof RegExpBranch)) {
                return;
            }
            InjectedLanguageManager injectedLanguageManager = InjectedLanguageManager.getInstance((Project)element2.getProject());
            TextRange range2 = descriptor2.getTextRangeInElement();
            StringBuilder text = new StringBuilder();
            boolean inserted = false;
            for (PsiElement child2 = element2.getFirstChild(); child2 != null; child2 = child2.getNextSibling()) {
                if (!range2.contains(child2.getStartOffsetInParent())) {
                    text.append(injectedLanguageManager.getUnescapedText(child2));
                    continue;
                }
                if (inserted) continue;
                text.append(" {").append(this.myCount).append('}');
                inserted = true;
            }
            RegExpReplacementUtil.replaceInContext(element2, text.toString());
        }
    }

    private static class RepeatedSpaceVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RepeatedSpaceVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpChar(RegExpChar aChar) {
            if (!RepeatedSpaceVisitor.isSpace(aChar) || RepeatedSpaceVisitor.isSpace(aChar.getPrevSibling()) || RepeatedSpaceVisitor.isInEscapeSequence(aChar)) {
                return;
            }
            PsiElement parent = aChar.getParent();
            if (parent instanceof RegExpClass || parent instanceof RegExpCharRange) {
                return;
            }
            int count = 1;
            int length = aChar.getTextLength();
            PsiElement next = aChar.getNextSibling();
            while (RepeatedSpaceVisitor.isSpace(next)) {
                ++count;
                length += next.getTextLength();
                next = next.getNextSibling();
            }
            if (count > 1) {
                String message = count + " consecutive spaces in RegExp";
                int offset = aChar.getStartOffsetInParent();
                this.myHolder.registerProblem(parent, new TextRange(offset, offset + length), message, new LocalQuickFix[]{new RepeatedSpaceFix(count)});
            }
        }

        private static boolean isInEscapeSequence(RegExpChar aChar) {
            PsiElement prev = aChar.getPrevSibling();
            while (prev instanceof RegExpChar) {
                prev = prev.getPrevSibling();
            }
            if (RepeatedSpaceVisitor.isEscapeSequenceStart(prev)) {
                return true;
            }
            PsiElement parent = aChar.getParent();
            if (prev != null || !(parent instanceof RegExpBranch)) {
                return false;
            }
            PsiElement grandParent = parent.getParent();
            return grandParent instanceof RegExpPattern && RepeatedSpaceVisitor.isEscapeSequenceStart(grandParent.getPrevSibling());
        }

        private static boolean isEscapeSequenceStart(@Nullable PsiElement element2) {
            return element2 instanceof PsiWhiteSpace && "\\Q".equals(InjectedLanguageManager.getInstance((Project)element2.getProject()).getUnescapedText(element2));
        }

        private static boolean isSpace(PsiElement element2) {
            if (!(element2 instanceof RegExpChar)) {
                return false;
            }
            RegExpChar aChar = (RegExpChar)element2;
            return aChar.getType() == RegExpChar.Type.CHAR && aChar.getValue() == 32;
        }
    }
}

