/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpClass;
import org.intellij.lang.regexp.psi.RegExpClassElement;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpIntersection;
import org.jetbrains.annotations.NotNull;

public class RedundantNestedCharacterClassInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new RedundantNestedCharacterClassVisitor(holder);
    }

    private static class RedundantNestedCharacterClassVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        RedundantNestedCharacterClassVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClass(RegExpClass regExpClass) {
            RegExpClass grandparentClass;
            PsiElement grandParent;
            super.visitRegExpClass(regExpClass);
            PsiElement parent = regExpClass.getParent();
            if (parent instanceof RegExpClass) {
                RegExpClass parentClass = (RegExpClass)parent;
                if (!parentClass.isNegated() && !regExpClass.isNegated()) {
                    this.myHolder.registerProblem(regExpClass.getFirstChild(), RegExpBundle.message("inspection.warning.redundant.nested.character.class", new Object[0]), new LocalQuickFix[]{new RedundantNestedCharacterClassFix()});
                }
            } else if (parent instanceof RegExpIntersection && (grandParent = parent.getParent()) instanceof RegExpClass && !(grandparentClass = (RegExpClass)grandParent).isNegated() && !regExpClass.isNegated()) {
                this.myHolder.registerProblem(regExpClass.getFirstChild(), RegExpBundle.message("inspection.warning.redundant.nested.character.class", new Object[0]), new LocalQuickFix[]{new RedundantNestedCharacterClassFix()});
            }
        }

        private static class RedundantNestedCharacterClassFix
        implements LocalQuickFix {
            private RedundantNestedCharacterClassFix() {
            }

            public @IntentionFamilyName @NotNull String getFamilyName() {
                return RegExpBundle.message("inspection.quick.fix.replace.redundant.character.class.with.contents", new Object[0]);
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
                PsiElement element2 = descriptor2.getPsiElement().getParent();
                if (element2 instanceof RegExpClass) {
                    RegExpClass regExpClass = (RegExpClass)element2;
                    RegExpClassElement[] elements2 = regExpClass.getElements();
                    PsiElement parent = regExpClass.getParent();
                    for (RegExpClassElement classElement : elements2) {
                        parent.addBefore((PsiElement)classElement, (PsiElement)regExpClass);
                    }
                    regExpClass.delete();
                }
            }
        }
    }
}

