/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.RegExpBundle;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyAlternationBranchInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        return new EmptyAlternationBranchVisitor(holder);
    }

    private static class EmptyAlternationBranchFix
    implements LocalQuickFix {
        private EmptyAlternationBranchFix() {
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            return RegExpBundle.message("inspection.quick.fix.remove.empty.branch", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2 = descriptor2.getPsiElement();
            if (!(element2.getParent() instanceof RegExpPattern)) {
                return;
            }
            element2.getNextSibling().delete();
            element2.delete();
        }
    }

    private static class EmptyAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EmptyAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            boolean emptyBranchSeen = false;
            for (int i2 = 0; i2 < branches.length; ++i2) {
                RegExpBranch branch = branches[i2];
                if (branch.getAtoms().length > 0) continue;
                if (i2 == 0) {
                    emptyBranchSeen = true;
                    continue;
                }
                if (!emptyBranchSeen && i2 == branches.length - 1) continue;
                this.myHolder.registerProblem(branch.getPrevSibling(), RegExpBundle.message("inspection.warning.empty.branch.in.alternation", new Object[0]), new LocalQuickFix[]{new EmptyAlternationBranchFix()});
            }
        }
    }
}

