/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.ui;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerBundle;
import javax.swing.Action;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InstancesWindowBase
extends DialogWrapper {
    protected static final int DEFAULT_WINDOW_WIDTH = 870;
    protected static final int DEFAULT_WINDOW_HEIGHT = 400;
    protected final String className;

    public InstancesWindowBase(@NotNull XDebugSession session2, @NotNull String className) {
        super(session2.getProject(), false);
        this.className = className;
        this.addWarningMessage(null);
        session2.addSessionListener(new XDebugSessionListener(){

            public void sessionStopped() {
                ApplicationManager.getApplication().invokeLater(() -> InstancesWindowBase.this.close(0));
            }
        }, this.myDisposable);
        this.setModal(false);
    }

    protected void addWarningMessage(@Nullable String message) {
        String warning = message == null ? "" : String.format(". Warning: %s", message);
        this.setTitle(String.format("Instances of %s%s", this.className, warning));
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "#org.jetbrains.debugger.memory.view.InstancesWindow";
    }

    protected Action @NotNull [] createActions() {
        return new Action[]{new DialogWrapper.DialogWrapperExitAction((DialogWrapper)this, XDebuggerBundle.message((String)"memory.instances.close.text", (Object[])new Object[0]), 1)};
    }
}

