/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.memory.ui;

import com.intellij.application.Topics;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ex.AnActionListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.messages.Topic;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.frame.XValueMarkers;
import com.intellij.xdebugger.impl.ui.tree.ValueMarkup;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeState;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.memory.ui.InstancesTree;
import com.intellij.xdebugger.memory.utils.InstancesProvider;
import java.awt.Color;
import java.awt.LayoutManager;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public abstract class InstancesViewBase
extends JBPanel
implements Disposable {
    private final InstancesProvider myInstancesProvider;

    public InstancesViewBase(@NotNull LayoutManager layout, @NotNull XDebugSession session2, InstancesProvider instancesProvider) {
        super(layout);
        this.myInstancesProvider = instancesProvider;
        MySessionListener debugSessionListener = new MySessionListener();
        session2.addSessionListener((XDebugSessionListener)debugSessionListener, (Disposable)this);
        XValueMarkers<?, ?> markers = this.getValueMarkers(session2);
        if (markers != null) {
            Topics.subscribe((Topic)AnActionListener.TOPIC, (Disposable)this, (Object)new MyActionListener(markers));
        }
    }

    protected XValueMarkers<?, ?> getValueMarkers(@NotNull XDebugSession session2) {
        return session2 instanceof XDebugSessionImpl ? ((XDebugSessionImpl)session2).getValueMarkers() : null;
    }

    protected abstract InstancesTree getInstancesTree();

    public void dispose() {
    }

    public InstancesProvider getInstancesProvider() {
        return this.myInstancesProvider;
    }

    private class MyActionListener
    implements AnActionListener {
        private final XValueMarkers<?, ?> myValueMarkers;

        private MyActionListener(XValueMarkers<?, ?> markers) {
            this.myValueMarkers = markers;
        }

        public void beforeActionPerformed(@NotNull AnAction action2, @NotNull DataContext dataContext, @NotNull AnActionEvent event) {
            XValueNodeImpl selectedNode;
            if (dataContext.getData(PlatformDataKeys.CONTEXT_COMPONENT) == InstancesViewBase.this.getInstancesTree() && (this.isAddToWatchesAction(action2) || this.isEvaluateExpressionAction(action2)) && (selectedNode = XDebuggerTreeActionBase.getSelectedNode(dataContext)) != null) {
                TreeNode currentNode = selectedNode;
                while (!InstancesViewBase.this.getInstancesTree().getRoot().equals(currentNode.getParent())) {
                    currentNode = currentNode.getParent();
                }
                XValue valueContainer = (XValue)currentNode.getValueContainer();
                String expression = valueContainer.getEvaluationExpression();
                if (expression != null) {
                    this.myValueMarkers.markValue(valueContainer, new ValueMarkup(expression.replace("@", ""), (Color)new JBColor(0, 0), null));
                }
                ApplicationManager.getApplication().invokeLater(() -> InstancesViewBase.this.getInstancesTree().rebuildTree(InstancesTree.RebuildPolicy.ONLY_UPDATE_LABELS));
            }
        }

        private boolean isAddToWatchesAction(AnAction action2) {
            String className = action2.getClass().getSimpleName();
            return action2 instanceof XDebuggerTreeActionBase && className.equals("XAddToWatchesAction");
        }

        private boolean isEvaluateExpressionAction(AnAction action2) {
            String className = action2.getClass().getSimpleName();
            return action2 instanceof XDebuggerActionBase && className.equals("EvaluateAction");
        }
    }

    private class MySessionListener
    implements XDebugSessionListener {
        private volatile XDebuggerTreeState myTreeState = null;

        private MySessionListener() {
        }

        public void sessionResumed() {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myTreeState = XDebuggerTreeState.saveState(InstancesViewBase.this.getInstancesTree());
                InstancesViewBase.this.getInstancesTree().setInfoMessage("The application is running");
            });
        }

        public void sessionPaused() {
            ApplicationManager.getApplication().invokeLater(() -> {
                XDebuggerTreeState state = this.myTreeState;
                InstancesTree tree = InstancesViewBase.this.getInstancesTree();
                if (state == null) {
                    tree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES);
                } else {
                    tree.rebuildTree(InstancesTree.RebuildPolicy.RELOAD_INSTANCES, state);
                }
            });
        }
    }
}

