/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.nodes;

import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueTextRendererBase;
import java.awt.Color;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XValuePresentationUtil {
    public static void renderValue(@NotNull String value2, @NotNull ColoredTextContainer text, @NotNull SimpleTextAttributes attributes, int maxLength, @Nullable String additionalCharsToEscape) {
        SimpleTextAttributes escapeAttributes = null;
        int lastOffset = 0;
        int length = maxLength == -1 ? value2.length() : Math.min(value2.length(), maxLength);
        for (int i2 = 0; i2 < length; ++i2) {
            char ch = value2.charAt(i2);
            int additionalCharIndex = -1;
            if (ch != '\n' && ch != '\r' && ch != '\t' && ch != '\b' && ch != '\f' && (additionalCharsToEscape == null || (additionalCharIndex = additionalCharsToEscape.indexOf(ch)) == -1)) continue;
            if (i2 > lastOffset) {
                text.append(value2.substring(lastOffset, i2), attributes);
            }
            lastOffset = i2 + 1;
            if (escapeAttributes == null) {
                TextAttributes fromHighlighter = DebuggerUIUtil.getColorScheme().getAttributes(DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
                escapeAttributes = fromHighlighter != null ? SimpleTextAttributes.fromTextAttributes((TextAttributes)fromHighlighter) : new SimpleTextAttributes(1, (Color)JBColor.GRAY);
            }
            if (additionalCharIndex == -1) {
                text.append("\\", escapeAttributes);
            }
            text.append(String.valueOf(XValuePresentationUtil.getEscapingSymbol(ch)), escapeAttributes);
        }
        if (lastOffset < length) {
            text.append(value2.substring(lastOffset, length), attributes);
        }
    }

    private static char getEscapingSymbol(char ch) {
        switch (ch) {
            case '\n': {
                return 'n';
            }
            case '\r': {
                return 'r';
            }
            case '\t': {
                return 't';
            }
            case '\b': {
                return 'b';
            }
            case '\f': {
                return 'f';
            }
        }
        return ch;
    }

    public static void appendSeparator(@NotNull ColoredTextContainer text, @NotNull String separator) {
        if (!separator.isEmpty()) {
            text.append(separator, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
    }

    @NotNull
    public static String computeValueText(@NotNull XValuePresentation presentation2) {
        XValuePresentationTextExtractor extractor = new XValuePresentationTextExtractor();
        presentation2.renderValue((XValuePresentation.XValueTextRenderer)extractor);
        return extractor.getText();
    }

    private static class XValuePresentationTextExtractor
    extends XValueTextRendererBase {
        private final StringBuilder myBuilder = new StringBuilder();

        XValuePresentationTextExtractor() {
        }

        public void renderValue(@NotNull String value2) {
            this.myBuilder.append(value2);
        }

        @Override
        protected void renderRawValue(@NotNull String value2, @NotNull TextAttributesKey key) {
            this.myBuilder.append(value2);
        }

        public void renderStringValue(@NotNull String value2, @Nullable String additionalSpecialCharsToHighlight, int maxLength) {
            this.myBuilder.append(value2);
        }

        public void renderComment(@NotNull String comment) {
            this.myBuilder.append(comment);
        }

        public void renderError(@NotNull String error) {
            this.myBuilder.append(error);
        }

        public void renderSpecialSymbol(@NotNull String symbol) {
            this.myBuilder.append(symbol);
        }

        public String getText() {
            return this.myBuilder.toString();
        }
    }
}

