/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.IntIntHashMap;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchNodeImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class XFetchValueActionBase
extends AnAction {
    public void update(@NotNull AnActionEvent e) {
        for (XValueNodeImpl node : XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext())) {
            if (!this.isEnabled(e, node)) continue;
            return;
        }
        e.getPresentation().setEnabled(false);
    }

    protected boolean isEnabled(@NotNull AnActionEvent event, @NotNull XValueNodeImpl node) {
        if (node instanceof WatchNodeImpl || node.isComputed()) {
            event.getPresentation().setEnabled(true);
            return true;
        }
        return false;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        List<XValueNodeImpl> nodes = XDebuggerTreeActionBase.getSelectedNodes(e.getDataContext());
        if (nodes.isEmpty()) {
            return;
        }
        ValueCollector valueCollector = this.createCollector(e);
        for (XValueNodeImpl node : nodes) {
            this.addToCollector(nodes, node, valueCollector);
        }
        valueCollector.processed = true;
        valueCollector.finish();
    }

    protected void addToCollector(@NotNull List<XValueNodeImpl> paths, @NotNull XValueNodeImpl valueNode, @NotNull ValueCollector valueCollector) {
        if (paths.size() > 1) {
            valueCollector.add(valueNode.getText().toString(), valueNode.getPath().getPathCount());
        } else {
            XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
            if (fullValueEvaluator == null || !fullValueEvaluator.isShowValuePopup()) {
                valueCollector.add(StringUtil.notNullize((String)DebuggerUIUtil.getNodeRawValue(valueNode)));
            } else {
                new CopyValueEvaluationCallback(valueNode, valueCollector).startFetchingValue(fullValueEvaluator);
            }
        }
    }

    @NotNull
    protected ValueCollector createCollector(@NotNull AnActionEvent e) {
        return new ValueCollector(XDebuggerTree.getTree(e.getDataContext()));
    }

    protected abstract void handle(Project var1, String var2, XDebuggerTree var3);

    private static final class CopyValueEvaluationCallback
    extends HeadlessValueEvaluationCallback {
        private final int myValueIndex;
        private final ValueCollector myValueCollector;

        CopyValueEvaluationCallback(@NotNull XValueNodeImpl node, @NotNull ValueCollector valueCollector) {
            super(node);
            this.myValueCollector = valueCollector;
            this.myValueIndex = valueCollector.acquire();
        }

        @Override
        protected void evaluationComplete(@NotNull String value2, @NotNull Project project) {
            this.myValueCollector.evaluationComplete(this.myValueIndex, value2);
        }
    }

    public class ValueCollector {
        private final List<String> values = new SmartList();
        private final IntIntHashMap indents = new IntIntHashMap();
        private final XDebuggerTree myTree;
        private volatile boolean processed;

        public ValueCollector(XDebuggerTree tree) {
            this.myTree = tree;
        }

        public void add(@NotNull String value2) {
            this.values.add(value2);
        }

        public void add(@NotNull String value2, int indent) {
            this.values.add(value2);
            this.indents.put(this.values.size() - 1, indent);
        }

        public void finish() {
            Project project = this.myTree.getProject();
            if (this.processed && !this.values.contains(null) && !project.isDisposed()) {
                int minIndent = Integer.MAX_VALUE;
                for (int indent : this.indents.getValues()) {
                    minIndent = Math.min(minIndent, indent);
                }
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < this.values.size(); ++i2) {
                    int indent;
                    if (i2 > 0) {
                        sb.append("\n");
                    }
                    if ((indent = this.indents.get(i2)) > 0) {
                        StringUtil.repeatSymbol((Appendable)sb, (char)' ', (int)(indent - minIndent));
                    }
                    sb.append(this.values.get(i2));
                }
                this.handleInCollector(project, sb.toString(), this.myTree);
            }
        }

        public void handleInCollector(Project project, String value2, XDebuggerTree tree) {
            XFetchValueActionBase.this.handle(project, value2, tree);
        }

        public int acquire() {
            int index = this.values.size();
            this.values.add(null);
            return index;
        }

        public void evaluationComplete(int index, @NotNull String value2) {
            AppUIUtil.invokeOnEdt(() -> {
                this.values.set(index, value2);
                this.finish();
            });
        }
    }
}

