/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.breakpoints;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.ex.http.HttpFileSystem;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.BreakpointManagerState;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.BreakpointState;
import com.intellij.xdebugger.impl.breakpoints.BreakpointsUsageCollector;
import com.intellij.xdebugger.impl.breakpoints.CustomizedBreakpointPresentation;
import com.intellij.xdebugger.impl.breakpoints.LineBreakpointState;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointUtil;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointsDialogState;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XBreakpointManagerImpl
implements XBreakpointManager {
    private static final Logger LOG = Logger.getInstance(XBreakpointManagerImpl.class);
    private final MultiMap<XBreakpointType, XBreakpointBase<?, ?, ?>> myBreakpoints = MultiMap.createLinkedSet();
    private final Map<XBreakpointType, Set<XBreakpointBase<?, ?, ?>>> myDefaultBreakpoints = new LinkedHashMap();
    private final Map<XBreakpointType, BreakpointState<?, ?, ?>> myBreakpointsDefaults = new LinkedHashMap();
    private final Set<XBreakpointBase<?, ?, ?>> myAllBreakpoints = new LinkedHashSet();
    private final Map<XBreakpointType, EventDispatcher<XBreakpointListener>> myDispatchers = new HashMap<XBreakpointType, EventDispatcher<XBreakpointListener>>();
    private XBreakpointsDialogState myBreakpointsDialogSettings;
    private volatile EventDispatcher<XBreakpointListener> myAllBreakpointsDispatcher;
    private final XLineBreakpointManager myLineBreakpointManager;
    private final Project myProject;
    private final XDebuggerManagerImpl myDebuggerManager;
    private final XDependentBreakpointManager myDependentBreakpointManager;
    private long myTime;
    private String myDefaultGroup;
    private RemovedBreakpointData myLastRemovedBreakpoint = null;
    private volatile boolean myFirstLoadDone = false;

    public XBreakpointManagerImpl(@NotNull Project project, @NotNull XDebuggerManagerImpl debuggerManager) {
        this.myProject = project;
        this.myDebuggerManager = debuggerManager;
        this.myDependentBreakpointManager = new XDependentBreakpointManager(this);
        this.myLineBreakpointManager = new XLineBreakpointManager(project);
        project.getMessageBus().connect().subscribe(XBreakpointListener.TOPIC, (Object)new XBreakpointListener(){

            public void breakpointAdded(@NotNull XBreakpoint breakpoint) {
                if (XBreakpointManagerImpl.this.myAllBreakpointsDispatcher != null) {
                    ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointAdded(breakpoint);
                }
            }

            public void breakpointRemoved(@NotNull XBreakpoint breakpoint) {
                if (XBreakpointManagerImpl.this.myAllBreakpointsDispatcher != null) {
                    ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointRemoved(breakpoint);
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint breakpoint) {
                if (XBreakpointManagerImpl.this.myAllBreakpointsDispatcher != null) {
                    ((XBreakpointListener)XBreakpointManagerImpl.this.myAllBreakpointsDispatcher.getMulticaster()).breakpointChanged(breakpoint);
                }
            }
        });
        XBreakpointType.EXTENSION_POINT_NAME.addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<XBreakpointType>(){

            public void extensionAdded(@NotNull XBreakpointType type, @NotNull PluginDescriptor pluginDescriptor) {
                WriteAction.run(() -> XBreakpointManagerImpl.this.addDefaultBreakpoint(type));
            }

            public void extensionRemoved(@NotNull XBreakpointType type, @NotNull PluginDescriptor pluginDescriptor) {
                WriteAction.run(() -> {
                    for (Object b : XBreakpointManagerImpl.this.getBreakpoints(type)) {
                        XBreakpoint bpt = (XBreakpoint)b;
                        XBreakpointManagerImpl.this.doRemoveBreakpointImpl(bpt, XBreakpointManagerImpl.this.isDefaultBreakpoint(bpt));
                    }
                    XBreakpointManagerImpl.this.myBreakpointsDefaults.remove(type);
                    XBreakpointManagerImpl.this.myDefaultBreakpoints.remove(type);
                });
            }
        }, (Disposable)project);
    }

    public void init() {
        Project project = this.myProject;
        if (!project.isDefault() && !ApplicationManager.getApplication().isUnitTestMode()) {
            HttpFileSystem.getInstance().addFileListener(this::updateBreakpointInFile, (Disposable)project);
        }
    }

    private void updateBreakpointInFile(VirtualFile file2) {
        ApplicationManager.getApplication().invokeLater(() -> {
            for (XBreakpointBase<?, ?, ?> breakpoint : this.getAllBreakpoints()) {
                XSourcePosition position = breakpoint.getSourcePosition();
                if (position == null || !Comparing.equal((Object)position.getFile(), (Object)file2)) continue;
                this.fireBreakpointChanged(breakpoint);
            }
        }, this.myProject.getDisposed());
    }

    public XLineBreakpointManager getLineBreakpointManager() {
        return this.myLineBreakpointManager;
    }

    public XDependentBreakpointManager getDependentBreakpointManager() {
        return this.myDependentBreakpointManager;
    }

    public XDebuggerManagerImpl getDebuggerManager() {
        return this.myDebuggerManager;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        return this.doAddBreakpoint(type, properties, false);
    }

    @NotNull
    public <T extends XBreakpointProperties> XBreakpoint<T> addDefaultBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties) {
        return this.doAddBreakpoint(type, properties, true);
    }

    @NotNull
    private <T extends XBreakpointProperties> XBreakpoint<T> doAddBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, @Nullable T properties, boolean defaultBreakpoint) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        XBreakpointBase<?, T, ?> breakpoint = this.createBreakpoint(type, properties, true, defaultBreakpoint);
        this.addBreakpoint(breakpoint, defaultBreakpoint, true);
        return breakpoint;
    }

    private <T extends XBreakpointProperties> XBreakpointBase<?, T, ?> createBreakpoint(XBreakpointType<XBreakpoint<T>, T> type, T properties, boolean enabled, boolean defaultBreakpoint) {
        BreakpointState state = new BreakpointState(enabled, type.getId(), defaultBreakpoint ? 0L : (this.myTime = this.myTime + 1L), type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults(type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        return new XBreakpointBase(type, this, properties, state);
    }

    private <T extends XBreakpointProperties> void addBreakpoint(XBreakpointBase<?, T, ?> breakpoint, boolean defaultBreakpoint, boolean initUI) {
        XBreakpointType<?, T> type = breakpoint.getType();
        if (defaultBreakpoint) {
            Set typeDefaultBreakpoints = this.myDefaultBreakpoints.computeIfAbsent(type, k -> new LinkedHashSet());
            typeDefaultBreakpoints.add(breakpoint);
        } else {
            this.myBreakpoints.putValue(type, breakpoint);
            if (initUI) {
                BreakpointsUsageCollector.reportNewBreakpoint(breakpoint, type, this.getDebuggerManager().getCurrentSession() != null);
            }
        }
        this.myAllBreakpoints.add(breakpoint);
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.registerBreakpoint((XLineBreakpointImpl)breakpoint, initUI);
        }
        this.sendBreakpointEvent(type, listener2 -> listener2.breakpointAdded((XBreakpoint)breakpoint));
    }

    @NotNull
    private XBreakpointListener<XBreakpoint<?>> getBreakpointDispatcherMulticaster() {
        return (XBreakpointListener)this.myProject.getMessageBus().syncPublisher(XBreakpointListener.TOPIC);
    }

    public void fireBreakpointChanged(XBreakpointBase<?, ?, ?> breakpoint) {
        if (!this.myAllBreakpoints.contains(breakpoint)) {
            return;
        }
        if (breakpoint instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.breakpointChanged((XLineBreakpointImpl)breakpoint);
        }
        this.sendBreakpointEvent(breakpoint.getType(), listener2 -> listener2.breakpointChanged((XBreakpoint)breakpoint));
    }

    public void removeBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.doRemoveBreakpoint(breakpoint);
    }

    public void removeDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!this.isDefaultBreakpoint(breakpoint)) {
            throw new IllegalStateException("Trying to remove not default breakpoint " + breakpoint);
        }
        this.doRemoveBreakpointImpl(breakpoint, true);
    }

    private void doRemoveBreakpoint(XBreakpoint<?> breakpoint) {
        if (this.isDefaultBreakpoint(breakpoint)) {
            breakpoint.setEnabled(false);
        } else {
            this.doRemoveBreakpointImpl(breakpoint, false);
        }
    }

    private void doRemoveBreakpointImpl(XBreakpoint<?> breakpoint, boolean isDefaultBreakpoint) {
        XBreakpointType type = breakpoint.getType();
        XBreakpointBase breakpointBase = (XBreakpointBase)breakpoint;
        if (isDefaultBreakpoint) {
            Set<XBreakpointBase<?, ?, ?>> typeDefaultBreakpoints = this.myDefaultBreakpoints.get(breakpoint.getType());
            if (typeDefaultBreakpoints != null) {
                typeDefaultBreakpoints.remove(breakpoint);
            }
        } else {
            this.myBreakpoints.remove((Object)type, (Object)breakpointBase);
        }
        this.myAllBreakpoints.remove(breakpointBase);
        if (breakpointBase instanceof XLineBreakpointImpl) {
            this.myLineBreakpointManager.unregisterBreakpoint((XLineBreakpointImpl)breakpointBase);
        }
        breakpointBase.dispose();
        this.sendBreakpointEvent(type, listener2 -> listener2.breakpointRemoved(breakpoint));
    }

    private void sendBreakpointEvent(XBreakpointType type, Consumer<XBreakpointListener<XBreakpoint<?>>> event) {
        if (this.myFirstLoadDone) {
            EventDispatcher<XBreakpointListener> dispatcher = this.myDispatchers.get(type);
            if (dispatcher != null) {
                event.consume((Object)dispatcher.getMulticaster());
            }
            event.consume(this.getBreakpointDispatcherMulticaster());
        }
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties) {
        return this.addLineBreakpoint(type, fileUrl, line, properties, false);
    }

    @NotNull
    public <T extends XBreakpointProperties> XLineBreakpoint<T> addLineBreakpoint(XLineBreakpointType<T> type, @NotNull String fileUrl, int line, @Nullable T properties, boolean temporary) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        LineBreakpointState state = new LineBreakpointState(true, type.getId(), fileUrl, line, temporary, ++this.myTime, type.getDefaultSuspendPolicy());
        this.getBreakpointDefaults((XBreakpointType)type).applyDefaults(state);
        state.setGroup(this.myDefaultGroup);
        XLineBreakpointImpl<T> breakpoint = new XLineBreakpointImpl<T>(type, this, properties, state);
        this.addBreakpoint(breakpoint, false, true);
        return breakpoint;
    }

    public XBreakpointBase<?, ?, ?> @NotNull [] getAllBreakpoints() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return this.myAllBreakpoints.toArray(new XBreakpointBase[0]);
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<B> result2 = new ArrayList<B>(this.getDefaultBreakpoints(type));
        result2.addAll(this.myBreakpoints.get(type));
        return Collections.unmodifiableList(result2);
    }

    @NotNull
    public <B extends XBreakpoint<?>> Collection<? extends B> getBreakpoints(@NotNull Class<? extends XBreakpointType<B, ?>> typeClass) {
        XBreakpointType type = XDebuggerUtil.getInstance().findBreakpointType(typeClass);
        LOG.assertTrue(type != null, (Object)("Unregistered breakpoint type " + typeClass + ", registered: " + Arrays.toString(XBreakpointType.EXTENSION_POINT_NAME.getExtensions())));
        return this.getBreakpoints(type);
    }

    @Nullable
    public <B extends XBreakpoint<?>> B getDefaultBreakpoint(@NotNull XBreakpointType<B, ?> type) {
        Set<B> defaultBreakpoints = this.getDefaultBreakpoints(type);
        return (B)((XBreakpoint)ContainerUtil.getFirstItem(defaultBreakpoints));
    }

    @NotNull
    public <B extends XBreakpoint<?>> Set<B> getDefaultBreakpoints(@NotNull XBreakpointType<B, ?> type) {
        Set<XBreakpointBase<?, ?, ?>> breakpointsSet = this.myDefaultBreakpoints.get(type);
        if (breakpointsSet == null) {
            return Collections.emptySet();
        }
        return breakpointsSet.stream().map(breakpoint -> breakpoint).collect(Collectors.toSet());
    }

    @Nullable
    public <P extends XBreakpointProperties> XLineBreakpoint<P> findBreakpointAtLine(@NotNull XLineBreakpointType<P> type, @NotNull VirtualFile file2, int line) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return StreamEx.of((Collection)this.myBreakpoints.get(type)).select(XLineBreakpoint.class).findFirst(b -> b.getFileUrl().equals(file2.getUrl()) && b.getLine() == line).orElse(null);
    }

    public boolean isDefaultBreakpoint(@NotNull XBreakpoint<?> breakpoint) {
        return this.myDefaultBreakpoints.values().stream().anyMatch(s -> s.contains(breakpoint));
    }

    private <T extends XBreakpointProperties> EventDispatcher<XBreakpointListener> getOrCreateDispatcher(XBreakpointType<?, T> type) {
        return this.myDispatchers.computeIfAbsent(type, k -> EventDispatcher.create(XBreakpointListener.class));
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        this.getOrCreateDispatcher(type).addListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void removeBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2) {
        this.getOrCreateDispatcher(type).removeListener(listener2);
    }

    public <B extends XBreakpoint<P>, P extends XBreakpointProperties> void addBreakpointListener(@NotNull XBreakpointType<B, P> type, @NotNull XBreakpointListener<B> listener2, Disposable parentDisposable) {
        this.getOrCreateDispatcher(type).addListener(listener2, parentDisposable);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2, @NotNull Disposable parentDisposable) {
        this.myProject.getMessageBus().connect(parentDisposable).subscribe(XBreakpointListener.TOPIC, listener2);
    }

    public void addBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        this.getDispatcher().addListener(listener2);
    }

    public void removeBreakpointListener(@NotNull XBreakpointListener<XBreakpoint<?>> listener2) {
        this.getDispatcher().removeListener(listener2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EventDispatcher<XBreakpointListener> getDispatcher() {
        Map<XBreakpointType, EventDispatcher<XBreakpointListener>> map2 = this.myDispatchers;
        synchronized (map2) {
            if (this.myAllBreakpointsDispatcher == null) {
                this.myAllBreakpointsDispatcher = EventDispatcher.create(XBreakpointListener.class);
            }
            return this.myAllBreakpointsDispatcher;
        }
    }

    public void updateBreakpointPresentation(@NotNull XLineBreakpoint<?> breakpoint, @Nullable Icon icon2, @Nullable String errorMessage) {
        XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)breakpoint;
        CustomizedBreakpointPresentation presentation2 = lineBreakpoint.getCustomizedPresentation();
        if (presentation2 == null) {
            if (icon2 == null && errorMessage == null) {
                return;
            }
            presentation2 = new CustomizedBreakpointPresentation();
        } else if (Comparing.equal((Object)presentation2.getIcon(), (Object)icon2) && Comparing.strEqual((String)presentation2.getErrorMessage(), (String)errorMessage)) {
            return;
        }
        presentation2.setErrorMessage(errorMessage);
        presentation2.setIcon(icon2);
        lineBreakpoint.setCustomizedPresentation(presentation2);
        this.myLineBreakpointManager.queueBreakpointUpdate((XBreakpoint<?>)breakpoint);
    }

    @NotNull
    public BreakpointManagerState saveState(@NotNull BreakpointManagerState state) {
        this.myDependentBreakpointManager.saveState();
        SmartList defaultBreakpoints = new SmartList();
        for (Set<XBreakpointBase<?, ?, ?>> typeDefaultBreakpoints : this.myDefaultBreakpoints.values()) {
            if (typeDefaultBreakpoints.stream().noneMatch(breakpoint -> this.differsFromDefault(breakpoint.getType(), (BreakpointState)breakpoint.getState()))) continue;
            for (XBreakpointBase xBreakpointBase : typeDefaultBreakpoints) {
                Object breakpointState = xBreakpointBase.getState();
                defaultBreakpoints.add(breakpointState);
            }
        }
        SmartList breakpoints = new SmartList();
        for (XBreakpointBase breakpoint3 : this.myBreakpoints.values()) {
            breakpoints.add(breakpoint3.getState());
        }
        SmartList breakpointsDefaults = new SmartList();
        for (Map.Entry entry : this.myBreakpointsDefaults.entrySet()) {
            if (!XBreakpointManagerImpl.statesAreDifferent((BreakpointState)entry.getValue(), XBreakpointManagerImpl.createBreakpointDefaults((XBreakpointType)entry.getKey()), false)) continue;
            breakpointsDefaults.add(entry.getValue());
        }
        state.getDefaultBreakpoints().clear();
        state.getDefaultBreakpoints().addAll((Collection<BreakpointState<?, ?, ?>>)defaultBreakpoints);
        state.getBreakpoints().clear();
        state.getBreakpoints().addAll((Collection<BreakpointState<?, ?, ?>>)breakpoints);
        state.getBreakpointsDefaults().clear();
        state.getBreakpointsDefaults().addAll((Collection<BreakpointState<?, ?, ?>>)breakpointsDefaults);
        state.setBreakpointsDialogProperties(this.myBreakpointsDialogSettings);
        state.setDefaultGroup(this.myDefaultGroup);
        return state;
    }

    private <P extends XBreakpointProperties> boolean differsFromDefault(XBreakpointType<?, P> type, BreakpointState state) {
        XBreakpoint<P> defaultBreakpoint = this.createDefaultBreakpoint(type);
        if (defaultBreakpoint == null) {
            return false;
        }
        Object defaultState = ((XBreakpointBase)defaultBreakpoint).getState();
        return XBreakpointManagerImpl.statesAreDifferent(state, defaultState, false);
    }

    public static boolean statesAreDifferent(BreakpointState state1, BreakpointState state2, boolean ignoreTimestamp) {
        Element elem2;
        Element elem1;
        boolean res2;
        long timeStamp1 = state1.getTimeStamp();
        long timeStamp2 = state2.getTimeStamp();
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp2);
        }
        boolean bl = res2 = !JDOMUtil.areElementsEqual((Element)(elem1 = XmlSerializer.serialize((Object)state1)), (Element)(elem2 = XmlSerializer.serialize((Object)state2)));
        if (ignoreTimestamp) {
            state1.setTimeStamp(timeStamp1);
        }
        return res2;
    }

    public void loadState(@NotNull BreakpointManagerState state) {
        this.myBreakpointsDialogSettings = state.getBreakpointsDialogProperties();
        this.myAllBreakpoints.clear();
        this.myDefaultBreakpoints.clear();
        this.myBreakpointsDefaults.clear();
        ApplicationManager.getApplication().runReadAction(() -> {
            state.getDefaultBreakpoints().forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, true));
            ((StreamEx)XBreakpointUtil.breakpointTypes().remove(this.myDefaultBreakpoints::containsKey)).forEach(this::addDefaultBreakpoint);
            new ArrayList<XBreakpointBase>(this.myBreakpoints.values()).forEach(this::doRemoveBreakpoint);
            ContainerUtil.notNullize(state.getBreakpoints()).forEach(breakpointState -> this.loadBreakpoint((BreakpointState)breakpointState, false));
            for (BreakpointState<?, ?, ?> defaults : state.getBreakpointsDefaults()) {
                XBreakpointType<?, ?> type = XBreakpointUtil.findType(defaults.getTypeId());
                if (type != null) {
                    this.myBreakpointsDefaults.put(type, defaults);
                    continue;
                }
                LOG.warn("Unknown breakpoint type " + defaults.getTypeId());
            }
            this.myDependentBreakpointManager.loadState();
        });
        this.myLineBreakpointManager.updateBreakpointsUI();
        this.myDefaultGroup = state.getDefaultGroup();
        this.myFirstLoadDone = true;
    }

    public void noStateLoaded() {
        this.myDefaultBreakpoints.clear();
        XBreakpointUtil.breakpointTypes().forEach(this::addDefaultBreakpoint);
        this.myFirstLoadDone = true;
    }

    private <P extends XBreakpointProperties> void addDefaultBreakpoint(@NotNull XBreakpointType<?, P> type) {
        XBreakpoint<P> breakpoint = this.createDefaultBreakpoint(type);
        if (breakpoint != null) {
            this.addBreakpoint((XBreakpointBase)breakpoint, true, false);
        }
    }

    @Nullable
    private <P extends XBreakpointProperties> XBreakpoint<P> createDefaultBreakpoint(XBreakpointType<? extends XBreakpoint<P>, P> type) {
        return type.createDefaultBreakpoint(properties -> this.createBreakpoint(type, properties, false, true));
    }

    private void loadBreakpoint(BreakpointState breakpointState, boolean defaultBreakpoint) {
        XBreakpointBase<?, ?, ?> breakpoint = this.createBreakpoint(breakpointState);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, defaultBreakpoint, false);
        }
        this.myTime = Math.max(this.myTime, breakpointState.getTimeStamp());
    }

    public XBreakpointsDialogState getBreakpointsDialogSettings() {
        return this.myBreakpointsDialogSettings;
    }

    public void setBreakpointsDialogSettings(XBreakpointsDialogState breakpointsDialogSettings) {
        this.myBreakpointsDialogSettings = breakpointsDialogSettings;
    }

    public Set<String> getAllGroups() {
        return StreamEx.of(this.myAllBreakpoints).map(XBreakpointBase::getGroup).nonNull().toSet();
    }

    public String getDefaultGroup() {
        return this.myDefaultGroup;
    }

    public void setDefaultGroup(String defaultGroup) {
        this.myDefaultGroup = defaultGroup;
    }

    @Nullable
    private XBreakpointBase<?, ?, ?> createBreakpoint(BreakpointState breakpointState) {
        XBreakpointType<?, ?> type = XBreakpointUtil.findType(breakpointState.getTypeId());
        if (type == null) {
            LOG.warn("Unknown breakpoint type " + breakpointState.getTypeId());
            return null;
        }
        return breakpointState.createBreakpoint(type, this);
    }

    @NotNull
    public BreakpointState getBreakpointDefaults(@NotNull XBreakpointType type) {
        return this.myBreakpointsDefaults.computeIfAbsent(type, k -> XBreakpointManagerImpl.createBreakpointDefaults(type));
    }

    @Nullable
    <T extends XBreakpointProperties> XLineBreakpoint<T> copyLineBreakpoint(@NotNull XLineBreakpoint<T> source, @NotNull String fileUrl, int line) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (!(source instanceof XLineBreakpointImpl)) {
            return null;
        }
        this.myDependentBreakpointManager.saveState();
        LineBreakpointState sourceState = (LineBreakpointState)((XLineBreakpointImpl)source).getState();
        Element element2 = XmlSerializer.serialize((Object)sourceState);
        LineBreakpointState newState2 = element2 == null ? new LineBreakpointState() : (LineBreakpointState)XmlSerializer.deserialize((Element)element2, LineBreakpointState.class);
        newState2.setLine(line);
        newState2.setFileUrl(fileUrl);
        XLineBreakpointImpl breakpoint = (XLineBreakpointImpl)this.createBreakpoint(newState2);
        if (breakpoint != null) {
            this.addBreakpoint(breakpoint, false, true);
            XBreakpoint<?> masterBreakpoint = this.myDependentBreakpointManager.getMasterBreakpoint((XBreakpoint<?>)source);
            if (masterBreakpoint != null) {
                this.myDependentBreakpointManager.setMasterBreakpoint(breakpoint, masterBreakpoint, sourceState.getDependencyState().isLeaveEnabled());
            }
        }
        return breakpoint;
    }

    @NotNull
    private static BreakpointState createBreakpointDefaults(@NotNull XBreakpointType type) {
        BreakpointState state = new BreakpointState();
        state.setTypeId(type.getId());
        state.setSuspendPolicy(type.getDefaultSuspendPolicy());
        return state;
    }

    public void rememberRemovedBreakpoint(@NotNull XBreakpointBase breakpoint) {
        this.myLastRemovedBreakpoint = new RemovedBreakpointData(breakpoint);
    }

    @Nullable
    public XBreakpointBase getLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null ? this.myLastRemovedBreakpoint.myBreakpoint : null;
    }

    @Nullable
    public XBreakpoint restoreLastRemovedBreakpoint() {
        if (this.myLastRemovedBreakpoint != null) {
            XBreakpoint breakpoint = this.myLastRemovedBreakpoint.restore();
            this.myLastRemovedBreakpoint = null;
            return breakpoint;
        }
        return null;
    }

    public boolean canRestoreLastRemovedBreakpoint() {
        return this.myLastRemovedBreakpoint != null && this.myLastRemovedBreakpoint.isRestorable();
    }

    private class RemovedBreakpointData {
        private final XBreakpointBase myBreakpoint;
        private final XDependentBreakpointManager.DependenciesData myDependenciesData;

        private RemovedBreakpointData(XBreakpointBase breakpoint) {
            this.myBreakpoint = breakpoint;
            XDependentBreakpointManager xDependentBreakpointManager = XBreakpointManagerImpl.this.myDependentBreakpointManager;
            xDependentBreakpointManager.getClass();
            this.myDependenciesData = new XDependentBreakpointManager.DependenciesData(xDependentBreakpointManager, breakpoint);
        }

        boolean isRestorable() {
            return !(this.myBreakpoint instanceof XLineBreakpointImpl) || ((XLineBreakpointImpl)this.myBreakpoint).getFile() != null;
        }

        @Nullable
        XBreakpoint restore() {
            XBreakpointBase breakpoint;
            if (this.myBreakpoint instanceof XLineBreakpointImpl) {
                XLineBreakpointImpl lineBreakpoint = (XLineBreakpointImpl)this.myBreakpoint;
                VirtualFile file2 = lineBreakpoint.getFile();
                if (file2 == null) {
                    return null;
                }
                XLineBreakpoint existingBreakpoint = XBreakpointManagerImpl.this.findBreakpointAtLine(lineBreakpoint.getType(), file2, lineBreakpoint.getLine());
                if (existingBreakpoint != null) {
                    XBreakpointManagerImpl.this.removeBreakpoint((XBreakpoint<?>)existingBreakpoint);
                }
            }
            if ((breakpoint = XBreakpointManagerImpl.this.createBreakpoint(this.myBreakpoint.getState())) != null) {
                XBreakpointManagerImpl.this.addBreakpoint(breakpoint, false, true);
                this.myDependenciesData.restore(breakpoint);
                return breakpoint;
            }
            return null;
        }
    }
}

