/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorCustomElementRenderer;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.FontPreferences;
import com.intellij.openapi.editor.impl.ComplementaryFontsRegistry;
import com.intellij.openapi.editor.impl.FontInfo;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.DocumentUtil;
import com.intellij.util.MathUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.intellij.xdebugger.ui.DebuggerColors;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class XDebuggerInlayUtil {
    public static final Key<Helper> HELPER_KEY = Key.create((String)"xdebug.inlay.helper");

    private static int getIdentifierEndOffset(@NotNull CharSequence text, int startOffset) {
        while (startOffset < text.length() && Character.isJavaIdentifierPart(text.charAt(startOffset))) {
            ++startOffset;
        }
        return startOffset;
    }

    public static void createInlay(@NotNull Project project, @NotNull VirtualFile file2, int offset, String inlayText) {
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor editor = FileEditorManager.getInstance((Project)project).getSelectedEditor(file2);
            if (editor instanceof TextEditor) {
                Editor e = ((TextEditor)editor).getEditor();
                CharSequence text = e.getDocument().getImmutableCharSequence();
                int insertOffset = XDebuggerInlayUtil.getIdentifierEndOffset(text, offset);
                e.getInlayModel().getInlineElementsInRange(insertOffset, insertOffset, MyRenderer.class).forEach(Disposer::dispose);
                e.getInlayModel().addInlineElement(insertOffset, (EditorCustomElementRenderer)new MyRenderer(inlayText));
            }
        });
    }

    public static void clearInlays(@NotNull Project project) {
        UIUtil.invokeLaterIfNeeded(() -> {
            FileEditor[] editors;
            for (FileEditor editor : editors = FileEditorManager.getInstance((Project)project).getAllEditors()) {
                if (!(editor instanceof TextEditor)) continue;
                Editor e = ((TextEditor)editor).getEditor();
                e.getInlayModel().getInlineElementsInRange(0, e.getDocument().getTextLength(), MyRenderer.class).forEach(Disposer::dispose);
            }
        });
    }

    public static void setupValuePlaceholders(@NotNull XDebugSessionImpl session2, boolean removePlaceholders) {
        XSourcePosition position;
        XSourcePosition xSourcePosition = position = removePlaceholders ? null : session2.getCurrentPosition();
        if (!removePlaceholders && position == null) {
            return;
        }
        Helper helper = (Helper)session2.getSessionData().getUserData(HELPER_KEY);
        if (helper == null) {
            return;
        }
        Project project = session2.getProject();
        PsiDocumentManager.getInstance((Project)project).performLaterWhenAllCommitted(() -> helper.setupValuePlaceholders(project, position));
    }

    public static boolean showValueInBlockInlay(@NotNull XDebugSessionImpl session2, @NotNull XValueNodeImpl node, @NotNull XSourcePosition position) {
        Helper helper = (Helper)session2.getSessionData().getUserData(HELPER_KEY);
        return helper != null && helper.showValueInBlockInlay(session2.getProject(), node, position);
    }

    public static void createBlockInlay(@NotNull Editor editor, int offset) {
        editor.getInlayModel().addBlockElement(offset, false, false, 0, (EditorCustomElementRenderer)new MyBlockRenderer());
    }

    public static void addValueToBlockInlay(@NotNull Editor editor, int offset, String inlayText) {
        int lineStartOffset = DocumentUtil.getLineStartOffset(offset, editor.getDocument());
        List inlays = editor.getInlayModel().getBlockElementsInRange(lineStartOffset, lineStartOffset, MyBlockRenderer.class);
        if (inlays.size() != 1) {
            return;
        }
        Inlay inlay = (Inlay)inlays.get(0);
        CharSequence text = editor.getDocument().getImmutableCharSequence();
        int identifierEndOffset = XDebuggerInlayUtil.getIdentifierEndOffset(text, offset);
        ((MyBlockRenderer)inlay.getRenderer()).addValue(offset, identifierEndOffset, inlayText);
        inlay.update();
    }

    public static void clearBlockInlays(@NotNull Editor editor) {
        editor.getInlayModel().getBlockElementsInRange(0, editor.getDocument().getTextLength(), MyBlockRenderer.class).forEach(Disposer::dispose);
    }

    private static class MyRenderer
    implements EditorCustomElementRenderer {
        private final String myText;

        private MyRenderer(String text) {
            this.myText = "(" + text + ")";
        }

        private static FontInfo getFontInfo(@NotNull Editor editor) {
            EditorColorsScheme colorsScheme = editor.getColorsScheme();
            FontPreferences fontPreferences = colorsScheme.getFontPreferences();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            int fontStyle = attributes == null ? 0 : attributes.getFontType();
            return ComplementaryFontsRegistry.getFontAbleToDisplay(97, fontStyle, fontPreferences, FontInfo.getFontRenderContext(editor.getContentComponent()));
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            FontInfo fontInfo = MyRenderer.getFontInfo(inlay.getEditor());
            return fontInfo.fontMetrics().stringWidth(this.myText);
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle r, @NotNull TextAttributes textAttributes) {
            Editor editor = inlay.getEditor();
            TextAttributes attributes = editor.getColorsScheme().getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            if (attributes == null) {
                return;
            }
            Color fgColor = attributes.getForegroundColor();
            if (fgColor == null) {
                return;
            }
            g.setColor(fgColor);
            FontInfo fontInfo = MyRenderer.getFontInfo(editor);
            g.setFont(fontInfo.getFont());
            FontMetrics metrics = fontInfo.fontMetrics();
            g.drawString(this.myText, r.x, r.y + metrics.getAscent());
        }
    }

    private static class MyBlockRenderer
    implements EditorCustomElementRenderer {
        private final SortedSet<ValueInfo> values = new TreeSet<ValueInfo>();

        private MyBlockRenderer() {
        }

        void addValue(int refStartOffset, int refEndOffset, @NotNull String value2) {
            ValueInfo info = new ValueInfo(refStartOffset, refEndOffset, value2);
            this.values.remove(info);
            this.values.add(info);
        }

        public int calcWidthInPixels(@NotNull Inlay inlay) {
            return 0;
        }

        public void paint(@NotNull Inlay inlay, @NotNull Graphics g, @NotNull Rectangle targetRegion, @NotNull TextAttributes textAttributes) {
            if (this.values.isEmpty()) {
                return;
            }
            Editor editor = inlay.getEditor();
            EditorColorsScheme colorsScheme = editor.getColorsScheme();
            TextAttributes attributes = colorsScheme.getAttributes(DebuggerColors.INLINED_VALUES_EXECUTION_LINE);
            if (attributes == null) {
                return;
            }
            Color fgColor = attributes.getForegroundColor();
            if (fgColor == null) {
                return;
            }
            g.setColor(fgColor);
            g.setFont(new Font(colorsScheme.getEditorFontName(), attributes.getFontType(), colorsScheme.getEditorFontSize()));
            int curX = 0;
            for (ValueInfo value2 : this.values) {
                curX += JBUIScale.scale((int)5);
                int xStart = editor.offsetToXY((int)((ValueInfo)value2).refStartOffset, (boolean)true, (boolean)false).x;
                int xEnd = editor.offsetToXY((int)((ValueInfo)value2).refEndOffset, (boolean)false, (boolean)true).x;
                int width = g.getFontMetrics().stringWidth(value2.value);
                curX = Math.max(curX, (xStart + xEnd - width) / 2);
                g.drawString(value2.value, curX, targetRegion.y + editor.getAscent());
                g.drawLine(MathUtil.clamp((int)(curX + width / 2), (int)xStart, (int)xEnd), targetRegion.y, curX + width / 2, targetRegion.y + 2);
                g.drawLine(curX, targetRegion.y + 2, curX + width, targetRegion.y + 2);
                curX += width;
            }
        }

        private static class ValueInfo
        implements Comparable<ValueInfo> {
            private final int refStartOffset;
            private final int refEndOffset;
            private final String value;

            private ValueInfo(int refStartOffset, int refEndOffset, String value2) {
                this.refStartOffset = refStartOffset;
                this.refEndOffset = refEndOffset;
                this.value = value2;
            }

            @Override
            public int compareTo(@NotNull ValueInfo o) {
                return this.refStartOffset - o.refStartOffset;
            }
        }
    }

    public static interface Helper {
        public void setupValuePlaceholders(@NotNull Project var1, @Nullable XSourcePosition var2);

        public boolean showValueInBlockInlay(@NotNull Project var1, @NotNull XValueNodeImpl var2, @NotNull XSourcePosition var3);
    }
}

