/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.workspaceModel.ide.impl.legacyBridge.facet;

import com.google.common.collect.HashBiMap;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetConfiguration;
import com.intellij.facet.FacetManagerBase;
import com.intellij.facet.FacetManagerImpl;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.facet.impl.FacetModelBase;
import com.intellij.facet.impl.FacetUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.workspaceModel.ide.JpsEntitySourcesKt;
import com.intellij.workspaceModel.ide.JpsImportedEntitySource;
import com.intellij.workspaceModel.ide.legacyBridge.ModuleBridge;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.bridgeEntities.BridgeModelEntitiesKt;
import com.intellij.workspaceModel.storage.bridgeEntities.FacetEntity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.serialization.facet.FacetState;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0010\b\u0010\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00070\u0010J\u0014\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0002J\u0017\u0010\u0013\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u001b\u0010\u0016\u001a\u0004\u0018\u00010\u00072\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\bH\u0000\u00a2\u0006\u0002\b\u0018J\u001b\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001aJ\u0019\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0012\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u001cJ\u001e\u0010\u001d\u001a\u00020\u000e2\u0016\u0010\u001e\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006J\u0015\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u0000H\u0000\u00a2\u0006\u0002\b\u001fJ\u0014\u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u0007J\u001c\u0010!\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\u0007R$\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0007\u0012\b\u0012\u0006\u0012\u0002\b\u00030\b0\u0006X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Lcom/intellij/workspaceModel/ide/impl/legacyBridge/facet/FacetModelBridge;", "Lcom/intellij/facet/impl/FacetModelBase;", "moduleBridge", "Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "(Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;)V", "entityToFacet", "Lcom/google/common/collect/HashBiMap;", "Lcom/intellij/workspaceModel/storage/bridgeEntities/FacetEntity;", "Lcom/intellij/facet/Facet;", "getEntityToFacet", "()Lcom/google/common/collect/HashBiMap;", "getModuleBridge", "()Lcom/intellij/workspaceModel/ide/legacyBridge/ModuleBridge;", "checkConsistency", "", "facetEntities", "", "createFacet", "entity", "getAllFacets", "", "()[Lcom/intellij/facet/Facet;", "getEntity", "facet", "getEntity$intellij_platform_workspaceModel_ide", "getFacet", "getFacet$intellij_platform_workspaceModel_ide", "getOrCreateFacet", "getOrCreateFacet$intellij_platform_workspaceModel_ide", "populateFrom", "mapping", "populateFrom$intellij_platform_workspaceModel_ide", "removeEntity", "updateEntity", "oldEntity", "newEntity", "intellij.platform.workspaceModel.ide"})
public class FacetModelBridge
extends FacetModelBase {
    @NotNull
    private final HashBiMap<FacetEntity, Facet<?>> entityToFacet;
    @NotNull
    private final ModuleBridge moduleBridge;

    @NotNull
    protected final HashBiMap<FacetEntity, Facet<?>> getEntityToFacet() {
        return this.entityToFacet;
    }

    @NotNull
    public Facet<?>[] getAllFacets() {
        Collection $this$toTypedArray$iv = this.entityToFacet.values();
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Facet[] facetArray = thisCollection$iv.toArray(new Facet[0]);
        if (facetArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        return facetArray;
    }

    @NotNull
    public final Facet<?> getOrCreateFacet$intellij_platform_workspaceModel_ide(@NotNull FacetEntity entity) {
        Object object;
        Map $this$getOrPut$iv = (Map)this.entityToFacet;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(entity);
        if (value$iv == null) {
            boolean bl = false;
            Facet<?> answer$iv = this.createFacet(entity);
            $this$getOrPut$iv.put(entity, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (Facet)object;
    }

    @Nullable
    public final Facet<?> getFacet$intellij_platform_workspaceModel_ide(@NotNull FacetEntity entity) {
        return (Facet)this.entityToFacet.get((Object)entity);
    }

    @Nullable
    public final FacetEntity getEntity$intellij_platform_workspaceModel_ide(@NotNull Facet<?> facet) {
        return (FacetEntity)this.entityToFacet.inverse().get(facet);
    }

    /*
     * WARNING - void declaration
     */
    private final Facet<?> createFacet(FacetEntity entity) {
        Facet<?> underlyingFacet;
        Facet<?> facet;
        FacetEntity it;
        boolean bl;
        boolean bl2;
        FacetEntity facetEntity;
        FacetTypeRegistry registry = FacetTypeRegistry.getInstance();
        FacetType facetType = registry.findFacetType(entity.getFacetType());
        FacetEntity facetEntity2 = entity.getUnderlyingFacet();
        if (facetEntity2 != null) {
            facetEntity = facetEntity2;
            bl2 = false;
            bl = false;
            it = facetEntity;
            boolean bl3 = false;
            facet = this.getOrCreateFacet$intellij_platform_workspaceModel_ide(it);
        } else {
            facet = underlyingFacet = null;
        }
        if (facetType == null) {
            Element element2;
            void $this$apply;
            facetEntity = new FacetState();
            bl2 = false;
            bl = false;
            it = facetEntity;
            Module module = this.moduleBridge;
            boolean bl4 = false;
            $this$apply.setName(entity.getName());
            $this$apply.setFacetType(entity.getFacetType());
            void v2 = $this$apply;
            String string = entity.getConfigurationXmlTag();
            if (string != null) {
                void it2;
                String string2 = string;
                boolean bl5 = false;
                boolean bl6 = false;
                String string3 = string2;
                void var14_17 = v2;
                boolean bl7 = false;
                Element element3 = JDOMUtil.load((CharSequence)((CharSequence)it2));
                v2 = var14_17;
                element2 = element3;
            } else {
                element2 = null;
            }
            v2.setConfiguration(element2);
            Unit unit = Unit.INSTANCE;
            return FacetManagerBase.createInvalidFacet(module, (FacetState)facetEntity, underlyingFacet, ProjectBundle.message((String)"error.message.unknown.facet.type.0", (Object[])new Object[]{entity.getFacetType()}), true, true);
        }
        FacetConfiguration configuration = facetType.createDefaultConfiguration();
        String configurationXmlTag = entity.getConfigurationXmlTag();
        if (configurationXmlTag != null) {
            FacetUtil.loadFacetConfiguration(configuration, JDOMUtil.load((CharSequence)configurationXmlTag));
        }
        Facet facet2 = facetType.createFacet((Module)this.moduleBridge, entity.getName(), configuration, underlyingFacet);
        EntitySource entitySource = entity.getEntitySource();
        if (!(entitySource instanceof JpsImportedEntitySource)) {
            entitySource = null;
        }
        JpsImportedEntitySource jpsImportedEntitySource = (JpsImportedEntitySource)entitySource;
        FacetManagerImpl.setExternalSource(facet2, (ProjectModelExternalSource)(jpsImportedEntitySource != null ? JpsEntitySourcesKt.toExternalSource(jpsImportedEntitySource) : null));
        return facet2;
    }

    public final void populateFrom(@NotNull HashBiMap<FacetEntity, Facet<?>> mapping2) {
        this.entityToFacet.putAll((Map)mapping2);
        this.facetsChanged();
    }

    public final void populateFrom$intellij_platform_workspaceModel_ide(@NotNull FacetModelBridge mapping2) {
        this.entityToFacet.putAll((Map)mapping2.entityToFacet);
        this.facetsChanged();
    }

    @Nullable
    public final Facet<?> removeEntity(@NotNull FacetEntity entity) {
        Facet removed = (Facet)this.entityToFacet.remove((Object)entity);
        this.facetsChanged();
        return removed;
    }

    @Nullable
    public final Facet<?> updateEntity(@NotNull FacetEntity oldEntity, @NotNull FacetEntity newEntity2) {
        Facet oldFacet = (Facet)this.entityToFacet.remove((Object)oldEntity);
        if (oldFacet != null) {
            ((Map)this.entityToFacet).put(newEntity2, oldFacet);
        }
        this.facetsChanged();
        return (Facet)this.entityToFacet.get((Object)newEntity2);
    }

    public final void checkConsistency(@NotNull List<FacetEntity> facetEntities) {
        Set facetEntitiesSet = CollectionsKt.toSet((Iterable)facetEntities);
        for (FacetEntity entity : facetEntities) {
            FacetEntity entityFromMapping;
            Set facetsFromStorage;
            Facet facet = (Facet)this.entityToFacet.get((Object)entity);
            if (facet == null) {
                throw (Throwable)new IllegalStateException("No facet registered for " + entity + " (name = " + entity.getName() + ')');
            }
            if (Intrinsics.areEqual((Object)facet.getName(), (Object)entity.getName()) ^ true) {
                throw (Throwable)new IllegalStateException("Different name");
            }
            Object object = this.entityToFacet.inverse().get((Object)facet);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            if (!(Intrinsics.areEqual((Object)(facetsFromStorage = SequencesKt.toSet(BridgeModelEntitiesKt.getFacets((entityFromMapping = (FacetEntity)object).getModule()))), (Object)facetEntitiesSet) ^ true)) continue;
            throw (Throwable)new IllegalStateException("Different set of facets from " + entity + " storage: expected " + facetEntitiesSet + " but was " + facetsFromStorage);
        }
        FacetEntity staleEntity = (FacetEntity)CollectionsKt.firstOrNull((Iterable)SetsKt.minus((Set)this.entityToFacet.keySet(), (Iterable)facetEntities));
        if (staleEntity != null) {
            throw (Throwable)new IllegalStateException("Stale entity " + staleEntity + " (name = " + staleEntity.getName() + ") in the mapping");
        }
    }

    @NotNull
    protected final ModuleBridge getModuleBridge() {
        return this.moduleBridge;
    }

    public FacetModelBridge(@NotNull ModuleBridge moduleBridge) {
        this.moduleBridge = moduleBridge;
        this.entityToFacet = HashBiMap.create();
    }
}

