/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.options.ex.SingleConfigurableEditor;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.TextFieldWithHistory;
import com.intellij.ui.TextFieldWithHistoryWithBrowseButton;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.panels.NonOpaquePanel;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.Consumer;
import com.intellij.util.NotNullProducer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ComparatorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwingHelper {
    private static final Logger LOG = Logger.getInstance(SwingHelper.class);
    private static final String DIALOG_RESIZED_TO_FIT_TEXT = "INTELLIJ_DIALOG_RESIZED_TO_FIT_TEXT";
    public static final String ELLIPSIS = "...";
    public static final String ERROR_STR = "www";

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, Component ... children2) {
        return SwingHelper.newGenericBoxPanel(true, childAlignmentX, children2);
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(Component ... children2) {
        return SwingHelper.newVerticalPanel(0.0f, children2);
    }

    @NotNull
    public static JPanel newLeftAlignedVerticalPanel(@NotNull Collection<Component> children2) {
        return SwingHelper.newVerticalPanel(0.0f, children2);
    }

    @NotNull
    public static JPanel newVerticalPanel(float childAlignmentX, @NotNull Collection<Component> children2) {
        return SwingHelper.newVerticalPanel(childAlignmentX, children2.toArray(new Component[0]));
    }

    @NotNull
    public static JPanel newHorizontalPanel(float childAlignmentY, Component ... children2) {
        return SwingHelper.newGenericBoxPanel(false, childAlignmentY, children2);
    }

    private static JPanel newGenericBoxPanel(boolean verticalOrientation, float childAlignment, Component ... children2) {
        JPanel panel2 = new JPanel();
        int axis = verticalOrientation ? 1 : 0;
        panel2.setLayout(new BoxLayout(panel2, axis));
        for (Component child2 : children2) {
            panel2.add(child2, Float.valueOf(childAlignment));
            if (!(child2 instanceof JComponent)) continue;
            JComponent jChild = (JComponent)child2;
            if (verticalOrientation) {
                jChild.setAlignmentX(childAlignment);
                continue;
            }
            jChild.setAlignmentY(childAlignment);
        }
        return panel2;
    }

    @NotNull
    public static JPanel wrapWithoutStretch(@NotNull JComponent component2) {
        JPanel panel2 = new JPanel(new FlowLayout(0, 0, 0));
        panel2.add(component2);
        return panel2;
    }

    @NotNull
    public static JPanel wrapWithHorizontalStretch(@NotNull JComponent component2) {
        JPanel panel2 = new JPanel(new BorderLayout(0, 0));
        panel2.add((Component)component2, "North");
        return panel2;
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithHistoryWithBrowseButton component2) {
        int childWidth = SwingHelper.calcWidthToFitText(((TextFieldWithHistory)component2.getChildComponent()).getTextEditor(), JBUIScale.scale((int)32));
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component2, childWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull TextFieldWithBrowseButton component2) {
        int childWidth = SwingHelper.calcWidthToFitText((JTextField)component2.getChildComponent(), JBUIScale.scale((int)20));
        SwingHelper.setPreferredWidthForComponentWithBrowseButton(component2, childWidth);
    }

    private static <T extends JComponent> void setPreferredWidthForComponentWithBrowseButton(@NotNull ComponentWithBrowseButton<T> component2, int childPrefWidth) {
        Dimension buttonPrefSize = component2.getButton().getPreferredSize();
        SwingHelper.setPreferredWidth(component2, childPrefWidth + buttonPrefSize.width);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField2) {
        SwingHelper.setPreferredWidthToFitText(textField2, JBUIScale.scale((int)15));
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField2, int additionalWidth) {
        SwingHelper.setPreferredSizeToFitText(textField2, StringUtil.notNullize((String)textField2.getText()), additionalWidth);
    }

    public static void setPreferredWidthToFitText(@NotNull JTextField textField2, @NotNull String text) {
        SwingHelper.setPreferredSizeToFitText(textField2, text, JBUIScale.scale((int)15));
    }

    private static void setPreferredSizeToFitText(@NotNull JTextField textField2, @NotNull String text, int additionalWidth) {
        int width = SwingHelper.calcWidthToFitText(textField2, text, additionalWidth);
        SwingHelper.setPreferredWidth(textField2, width);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField2, int additionalWidth) {
        return SwingHelper.calcWidthToFitText(textField2, textField2.getText(), additionalWidth);
    }

    private static int calcWidthToFitText(@NotNull JTextField textField2, @NotNull String text, int additionalWidth) {
        return textField2.getFontMetrics(textField2.getFont()).stringWidth(text) + additionalWidth;
    }

    public static void adjustDialogSizeToFitPreferredSize(@NotNull DialogWrapper dialogWrapper2) {
        JRootPane rootPane = dialogWrapper2.getRootPane();
        if (rootPane == null) {
            return;
        }
        Dimension componentSize = rootPane.getSize();
        Dimension componentPreferredSize = rootPane.getPreferredSize();
        if (componentPreferredSize.width <= componentSize.width && componentPreferredSize.height <= componentSize.height) {
            return;
        }
        int dw = Math.max(0, componentPreferredSize.width - componentSize.width);
        int dh = Math.max(0, componentPreferredSize.height - componentSize.height);
        Dimension oldDialogSize = dialogWrapper2.getSize();
        Dimension newDialogSize = new Dimension(oldDialogSize.width + dw, oldDialogSize.height + dh);
        dialogWrapper2.setSize(newDialogSize.width, newDialogSize.height);
        rootPane.revalidate();
        rootPane.repaint();
        LOG.debug("DialogWrapper '" + dialogWrapper2.getTitle() + "' has been re-sized (added width: " + dw + ", added height: " + dh + ")");
    }

    public static void resizeDialogToFitTextFor(JComponent ... components) {
        if (components.length == 0) {
            return;
        }
        SwingHelper.doWithDialogWrapper(components[0], (Consumer<? super DialogWrapper>)((Consumer)dialogWrapper2 -> {
            if (dialogWrapper2 instanceof SettingsDialog || dialogWrapper2 instanceof SingleConfigurableEditor) {
                for (JComponent component2 : components) {
                    if (component2 instanceof TextFieldWithHistoryWithBrowseButton) {
                        SwingHelper.setPreferredWidthToFitText((TextFieldWithHistoryWithBrowseButton)component2);
                        continue;
                    }
                    if (component2 instanceof TextFieldWithBrowseButton) {
                        SwingHelper.setPreferredWidthToFitText((TextFieldWithBrowseButton)component2);
                        continue;
                    }
                    if (!(component2 instanceof JTextField)) continue;
                    SwingHelper.setPreferredWidthToFitText((JTextField)component2);
                }
                ApplicationManager.getApplication().invokeLater(() -> SwingHelper.adjustDialogSizeToFitPreferredSize(dialogWrapper2), ModalityState.any());
            }
        }));
    }

    private static void doWithDialogWrapper(@NotNull JComponent component2, @NotNull Consumer<? super DialogWrapper> consumer) {
        UIUtil.invokeLaterIfNeeded(() -> {
            if (component2.getClientProperty(DIALOG_RESIZED_TO_FIT_TEXT) != null) {
                return;
            }
            component2.putClientProperty(DIALOG_RESIZED_TO_FIT_TEXT, true);
            DialogWrapper dialogWrapper2 = DialogWrapper.findInstance((Component)component2);
            if (dialogWrapper2 != null) {
                consumer.consume((Object)dialogWrapper2);
            } else {
                UiNotifyConnector.doWhenFirstShown((JComponent)component2, () -> {
                    DialogWrapper dialogWrapper1 = DialogWrapper.findInstance((Component)component2);
                    if (dialogWrapper1 != null) {
                        consumer.consume((Object)dialogWrapper1);
                    }
                });
            }
        });
    }

    public static <T> void updateItems(@NotNull JComboBox<T> comboBox2, @NotNull List<? extends T> newItems, @Nullable T newSelectedItemIfSelectionCannotBePreserved) {
        if (!SwingHelper.shouldUpdate(comboBox2, newItems)) {
            return;
        }
        Object itemToSelect = comboBox2.getSelectedItem();
        boolean preserveSelection = true;
        if (!newItems.contains(itemToSelect)) {
            if (newItems.contains(newSelectedItemIfSelectionCannotBePreserved)) {
                itemToSelect = newSelectedItemIfSelectionCannotBePreserved;
            } else {
                itemToSelect = null;
                preserveSelection = false;
            }
        }
        comboBox2.removeAllItems();
        for (T newItem : newItems) {
            comboBox2.addItem(newItem);
        }
        if (preserveSelection) {
            int count = comboBox2.getItemCount();
            for (int i2 = 0; i2 < count; ++i2) {
                T item = comboBox2.getItemAt(i2);
                if (!ComparatorUtil.equalsNullable((Object)itemToSelect, item)) continue;
                comboBox2.setSelectedIndex(i2);
                break;
            }
        }
    }

    private static <T> boolean shouldUpdate(@NotNull JComboBox<T> comboBox2, @NotNull List<? extends T> newItems) {
        int count = comboBox2.getItemCount();
        if (newItems.size() != count) {
            return true;
        }
        for (int i2 = 0; i2 < count; ++i2) {
            T newItem;
            T oldItem = comboBox2.getItemAt(i2);
            if (ComparatorUtil.equalsNullable(oldItem, newItem = newItems.get(i2))) continue;
            return true;
        }
        return false;
    }

    public static void setNoBorderCellRendererFor(@NotNull TableColumn column) {
        final TableCellRenderer previous = column.getCellRenderer();
        column.setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value2, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component2 = previous != null ? previous.getTableCellRendererComponent(table, value2, isSelected, false, row, column) : super.getTableCellRendererComponent(table, value2, isSelected, false, row, column);
                if (component2 instanceof JComponent) {
                    ((JComponent)component2).setBorder(null);
                }
                return component2;
            }
        });
    }

    public static void addHistoryOnExpansion(final @NotNull TextFieldWithHistory textFieldWithHistory, final @NotNull NotNullProducer<? extends List<String>> historyProvider) {
        textFieldWithHistory.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                List history = (List)historyProvider.produce();
                SwingHelper.setHistory(textFieldWithHistory, ContainerUtil.notNullize((List)history), true);
                textFieldWithHistory.removePopupMenuListener((PopupMenuListener)this);
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    public static void setHistory(@NotNull TextFieldWithHistory textFieldWithHistory, @NotNull List<String> history, boolean mergeWithPrevHistory) {
        HashSet<String> newHistorySet = new HashSet<String>(history);
        List prevHistory = textFieldWithHistory.getHistory();
        ArrayList<String> mergedHistory = new ArrayList<String>(history.size());
        if (mergeWithPrevHistory) {
            for (String item : prevHistory) {
                if (newHistorySet.contains(item)) continue;
                mergedHistory.add(item);
            }
        }
        mergedHistory.addAll(history);
        String oldText = StringUtil.notNullize((String)textFieldWithHistory.getText());
        String oldSelectedItem = (String)ObjectUtils.tryCast((Object)textFieldWithHistory.getSelectedItem(), String.class);
        if (!mergedHistory.contains(oldSelectedItem)) {
            oldSelectedItem = null;
        }
        textFieldWithHistory.setHistory(mergedHistory);
        SwingHelper.setLongestAsPrototype((JComboBox)textFieldWithHistory, mergedHistory);
        if (oldSelectedItem != null) {
            textFieldWithHistory.setSelectedItem((Object)oldSelectedItem);
        }
        if (!oldText.equals(oldSelectedItem)) {
            textFieldWithHistory.setText(oldText);
        }
    }

    private static void setLongestAsPrototype(@NotNull JComboBox comboBox2, @NotNull List<String> variants) {
        Object prototypeDisplayValue = comboBox2.getPrototypeDisplayValue();
        String prototypeDisplayValueStr = null;
        if (prototypeDisplayValue instanceof String) {
            prototypeDisplayValueStr = (String)prototypeDisplayValue;
        } else if (prototypeDisplayValue != null) {
            return;
        }
        String longest = StringUtil.notNullize((String)prototypeDisplayValueStr);
        boolean updated = false;
        for (String s : variants) {
            if (longest.length() >= s.length()) continue;
            longest = s;
            updated = true;
        }
        if (updated) {
            comboBox2.setPrototypeDisplayValue(longest);
        }
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull TextFieldWithHistoryWithBrowseButton textFieldWithHistoryWithBrowseButton, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2) {
        SwingHelper.doInstall(project, textFieldWithHistoryWithBrowseButton, ((TextFieldWithHistory)textFieldWithHistoryWithBrowseButton.getChildComponent()).getTextEditor(), browseDialogTitle, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WITH_HISTORY_WHOLE_TEXT);
    }

    public static void installFileCompletionAndBrowseDialog(@Nullable Project project, @NotNull TextFieldWithBrowseButton textFieldWithBrowseButton2, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2) {
        SwingHelper.doInstall(project, textFieldWithBrowseButton2, textFieldWithBrowseButton2.getTextField(), browseDialogTitle, fileChooserDescriptor2, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
    }

    private static <T extends JComponent> void doInstall(@Nullable Project project, @NotNull ComponentWithBrowseButton<T> componentWithBrowseButton, @NotNull JTextField textField2, @NotNull @Nls(capitalization=Nls.Capitalization.Title) String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2, @NotNull TextComponentAccessor<T> textComponentAccessor) {
        ComponentsKt.installFileCompletionAndBrowseDialog(project, componentWithBrowseButton, textField2, browseDialogTitle, fileChooserDescriptor2.withShowHiddenFiles(SystemInfo.isUnix), textComponentAccessor);
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String url) {
        return SwingHelper.createWebHyperlink(url, url);
    }

    @NotNull
    public static HyperlinkLabel createWebHyperlink(@NotNull String text, @NotNull String url) {
        HyperlinkLabel hyperlink = new HyperlinkLabel(text);
        hyperlink.setHyperlinkTarget(url);
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        actionGroup.add((AnAction)new OpenLinkInBrowser(url));
        actionGroup.add((AnAction)new CopyLinkAction(url));
        hyperlink.setComponentPopupMenu(ActionManager.getInstance().createActionPopupMenu("web hyperlink", (ActionGroup)actionGroup).getComponent());
        return hyperlink;
    }

    public static void setPreferredWidth(@NotNull Component component2, int width) {
        Dimension preferredSize = component2.getPreferredSize();
        preferredSize.width = width;
        component2.setPreferredSize(preferredSize);
    }

    public static boolean scrollToReference(JEditorPane view, String reference2) {
        reference2 = StringUtil.trimStart((String)reference2, (String)"#");
        List<String> toCheck = Arrays.asList("a", "h1", "h2", "h3", "h4");
        Document document = view.getDocument();
        if (document instanceof HTMLDocument) {
            ArrayList list2 = new ArrayList();
            for (Element root : document.getRootElements()) {
                SwingHelper.getAllElements(root, list2, toCheck);
            }
            for (Element element2 : list2) {
                AttributeSet attributes = element2.getAttributes();
                String nm = (String)attributes.getAttribute(HTML.Attribute.NAME);
                if (nm == null) {
                    nm = (String)attributes.getAttribute(HTML.Attribute.ID);
                }
                if (nm == null || !nm.equals(reference2)) continue;
                try {
                    int pos = element2.getStartOffset();
                    Rectangle r = view.modelToView(pos);
                    if (r == null) continue;
                    Rectangle vis = view.getVisibleRect();
                    r.y -= 5;
                    r.height = vis.height;
                    view.scrollRectToVisible(r);
                    return true;
                }
                catch (BadLocationException badLocationException) {
                }
            }
        }
        return false;
    }

    private static void getAllElements(Element root, List<? super Element> list2, List<String> toCheck) {
        if (toCheck.contains(StringUtil.toLowerCase((String)root.getName()))) {
            list2.add(root);
        }
        for (int i2 = 0; i2 < root.getElementCount(); ++i2) {
            SwingHelper.getAllElements(root.getElement(i2), list2, toCheck);
        }
    }

    @NotNull
    public static JEditorPane createHtmlViewer(boolean lineWrap, @Nullable Font font, @Nullable Color background, @Nullable Color foreground) {
        JEditorPane textPane = lineWrap ? new JEditorPane(){

            @Override
            public Dimension getPreferredSize() {
                Dimension dimension = super.getPreferredSize();
                dimension.width = 0;
                return dimension;
            }
        } : new JEditorPane();
        UISettings.setupComponentAntialiasing((JComponent)textPane);
        textPane.setFont(font != null ? font : UIUtil.getLabelFont());
        textPane.setEditorKit(UIUtil.getHTMLEditorKit());
        textPane.setEditable(false);
        if (background != null) {
            textPane.setBackground(background);
        } else {
            NonOpaquePanel.setTransparent((JComponent)textPane);
        }
        textPane.setForeground(foreground != null ? foreground : UIUtil.getLabelForeground());
        textPane.setFocusable(false);
        return textPane;
    }

    public static void setHtml(@NotNull JEditorPane editorPane, @NotNull String bodyInnerHtml, @Nullable Color foregroundColor) {
        editorPane.setText(SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)editorPane.getFont(), (Color)foregroundColor, (Color)JBUI.CurrentTheme.Link.linkColor(), null), bodyInnerHtml));
    }

    @NotNull
    public static String buildHtml(@NotNull String headInnerHtml, @NotNull String bodyInnedHtml) {
        return "<html><head>" + headInnerHtml + "</head><body>" + bodyInnedHtml + "</body></html>";
    }

    @NotNull
    public static TextFieldWithHistoryWithBrowseButton createTextFieldWithHistoryWithBrowseButton(@Nullable Project project, @NotNull String browseDialogTitle, @NotNull FileChooserDescriptor fileChooserDescriptor2, @Nullable NotNullProducer<? extends List<String>> historyProvider) {
        return ComponentsKt.textFieldWithHistoryWithBrowseButton(project, browseDialogTitle, fileChooserDescriptor2, (Function0<? extends List<String>>)(historyProvider == null ? null : () -> (List)historyProvider.produce()));
    }

    @NotNull
    public static <C extends JComponent> ComponentWithBrowseButton<C> wrapWithInfoButton(@NotNull C component2, @NotNull String infoButtonTooltip, @NotNull ActionListener listener2) {
        ComponentWithBrowseButton comp = new ComponentWithBrowseButton(component2, listener2);
        FixedSizeButton uiHelpButton = comp.getButton();
        uiHelpButton.setToolTipText(infoButtonTooltip);
        uiHelpButton.setIcon(UIUtil.getBalloonInformationIcon());
        uiHelpButton.setHorizontalAlignment(0);
        uiHelpButton.setVerticalAlignment(0);
        return comp;
    }

    public static String truncateStringWithEllipsis(String text, int maxWidth, final FontMetrics fm) {
        return SwingHelper.truncateStringWithEllipsis(text, maxWidth, new WidthCalculator(){

            @Override
            public int stringWidth(String s) {
                return fm.stringWidth(s);
            }

            @Override
            public int charWidth(char c) {
                return fm.charWidth(c);
            }
        });
    }

    public static String truncateStringWithEllipsis(@NotNull String text, int maxWidth, WidthCalculator fm) {
        int error = fm.stringWidth(ERROR_STR);
        int wholeWidth = fm.stringWidth(text) + error;
        if (wholeWidth <= maxWidth || text.isEmpty()) {
            return text;
        }
        int ellipsisWidth = fm.stringWidth(ELLIPSIS) + error;
        if (ellipsisWidth >= maxWidth) {
            return ELLIPSIS;
        }
        int availableWidth = maxWidth - ellipsisWidth;
        int currentLen = (int)Math.floor((double)availableWidth / ((double)wholeWidth / (double)text.length()));
        String currentSubstring = text.substring(0, currentLen);
        int realWidth = fm.stringWidth(currentSubstring);
        int delta = 0;
        if (realWidth >= availableWidth) {
            for (int i2 = currentLen - 1; i2 >= 0; --i2) {
                if (realWidth - delta < availableWidth) {
                    return text.substring(0, i2) + ELLIPSIS;
                }
                delta += fm.charWidth(currentSubstring.charAt(i2));
            }
            return text.charAt(0) + ELLIPSIS;
        }
        for (int i3 = currentLen; i3 < text.length(); ++i3) {
            if (realWidth + delta >= availableWidth) {
                return text.substring(0, i3) + ELLIPSIS;
            }
            delta += fm.charWidth(text.charAt(i3));
        }
        return text.substring(0, currentLen) + ELLIPSIS;
    }

    public static JEditorPane createHtmlLabel(@NotNull String innerHtml, @Nullable String disabledHtml, final @Nullable Consumer<? super String> hyperlinkListener) {
        disabledHtml = disabledHtml == null ? innerHtml : disabledHtml;
        Font font = UIUtil.getLabelFont();
        String html = SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getActiveTextColor(), null, null), innerHtml);
        String disabled = SwingHelper.buildHtml(UIUtil.getCssFontDeclaration((Font)font, (Color)UIUtil.getInactiveTextColor(), null, null), disabledHtml);
        JEditorPane pane2 = new HtmlViewerBuilder().setCarryTextOver(false).setFont(UIUtil.getLabelFont()).setDisabledHtml(disabled).create();
        pane2.setText(html);
        pane2.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    if (hyperlinkListener != null) {
                        hyperlinkListener.consume((Object)(e.getURL() == null ? "" : e.getURL().toString()));
                    } else {
                        BrowserUtil.browse((URL)e.getURL());
                    }
                }
            }
        });
        return pane2;
    }

    @Nullable
    public static Component getComponentFromRecentMouseEvent() {
        MouseEvent mouseEvent;
        Component component2;
        AWTEvent event = IdeEventQueue.getInstance().getTrueCurrentEvent();
        if (event instanceof MouseEvent && (component2 = (mouseEvent = (MouseEvent)event).getComponent()) != null && (component2 = SwingUtilities.getDeepestComponentAt(component2, mouseEvent.getX(), mouseEvent.getY())) != null) {
            if (component2 instanceof JTabbedPane) {
                mouseEvent = SwingUtilities.convertMouseEvent(mouseEvent.getComponent(), mouseEvent, component2);
                JTabbedPane tabbedPane = (JTabbedPane)component2;
                int index = tabbedPane.getUI().tabForCoordinate(tabbedPane, mouseEvent.getX(), mouseEvent.getY());
                if (index != -1) {
                    return tabbedPane.getComponentAt(index);
                }
            }
            return component2;
        }
        return null;
    }

    public static interface WidthCalculator {
        public int stringWidth(String var1);

        public int charWidth(char var1);
    }

    private static class OpenLinkInBrowser
    extends DumbAwareAction {
        private final String myUrl;

        private OpenLinkInBrowser(@NotNull String url) {
            super(IdeBundle.message((String)"action.text.open.link.in.browser", (Object[])new Object[0]), null, PlatformIcons.WEB_ICON);
            this.myUrl = url;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            BrowserUtil.browse((String)this.myUrl);
        }
    }

    private static class CopyLinkAction
    extends DumbAwareAction {
        private final String myUrl;

        private CopyLinkAction(@NotNull String url) {
            super(IdeBundle.message((String)"action.text.copy.link.address", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON);
            this.myUrl = url;
        }

        public void update(@NotNull AnActionEvent e) {
            e.getPresentation().setEnabled(true);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            StringSelection content2 = new StringSelection(this.myUrl);
            CopyPasteManager.getInstance().setContents((Transferable)content2);
        }
    }

    public static class HtmlViewerBuilder {
        private boolean myCarryTextOver;
        private String myDisabledHtml;
        private Font myFont;
        private Color myBackground;
        private Color myForeground;

        public JEditorPane create() {
            JEditorPane textPane = new JEditorPane(){
                private boolean myEnabled = true;
                private String myEnabledHtml;

                @Override
                public Dimension getPreferredSize() {
                    Dimension dimension = super.getPreferredSize();
                    if (myCarryTextOver) {
                        dimension.width = 0;
                    }
                    return dimension;
                }

                @Override
                public void setText(String t) {
                    if (myDisabledHtml != null && this.myEnabled) {
                        this.myEnabledHtml = t;
                    }
                    super.setText(t);
                }

                @Override
                public void setEnabled(boolean enabled) {
                    if (myDisabledHtml != null) {
                        this.myEnabled = enabled;
                        if (this.myEnabled) {
                            this.setText(this.myEnabledHtml);
                        } else {
                            this.setText(myDisabledHtml);
                        }
                        super.setEnabled(true);
                    } else {
                        super.setEnabled(enabled);
                    }
                }
            };
            textPane.setFont(this.myFont != null ? this.myFont : UIUtil.getLabelFont());
            textPane.setContentType("text/html");
            textPane.setEditable(false);
            if (this.myBackground != null) {
                textPane.setBackground(this.myBackground);
            } else {
                textPane.setOpaque(false);
            }
            textPane.setForeground(this.myForeground != null ? this.myForeground : UIUtil.getLabelForeground());
            textPane.setFocusable(false);
            return textPane;
        }

        public HtmlViewerBuilder setCarryTextOver(boolean carryTextOver) {
            this.myCarryTextOver = carryTextOver;
            return this;
        }

        public HtmlViewerBuilder setDisabledHtml(String disabledHtml) {
            this.myDisabledHtml = disabledHtml;
            return this;
        }

        public HtmlViewerBuilder setFont(Font font) {
            this.myFont = font;
            return this;
        }

        public HtmlViewerBuilder setBackground(Color background) {
            this.myBackground = background;
            return this;
        }

        public HtmlViewerBuilder setForeground(Color foreground) {
            this.myForeground = foreground;
            return this;
        }
    }
}

