/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.ui.ListUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ListItemEditor;
import com.intellij.util.ui.ListModelEditorBase;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ListModelEditor<T>
extends ListModelEditorBase<T> {
    private final ToolbarDecorator toolbarDecorator;
    private final JBList<T> list;

    public ListModelEditor(@NotNull ListItemEditor<T> itemEditor) {
        super(itemEditor);
        this.list = new JBList((ListModel)((Object)this.model));
        this.list.setSelectionMode(0);
        this.list.setCellRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", o -> itemEditor.getName(o)));
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.list, (EditableModel)this.model).setAddAction(button2 -> {
            Object lastItem;
            if (!this.model.isEmpty() && ((ListItemEditor)this.itemEditor).isEmpty(lastItem = this.model.getElementAt(this.model.getSize() - 1))) {
                ScrollingUtil.selectItem(this.list, (int)ContainerUtil.indexOfIdentity((List)this.model.getItems(), (Object)lastItem));
                return;
            }
            Object item = this.createElement();
            this.model.add(item);
            ScrollingUtil.selectItem(this.list, (int)ContainerUtil.indexOfIdentity((List)this.model.getItems(), item));
        }).setRemoveActionUpdater(e -> this.areSelectedItemsRemovable(this.list.getSelectionModel()));
    }

    @NotNull
    public ListModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        return this;
    }

    @NotNull
    public JComponent createComponent() {
        return this.toolbarDecorator.createPanel();
    }

    @NotNull
    public JBList getList() {
        return this.list;
    }

    @Nullable
    public T getSelected() {
        return (T)this.list.getSelectedValue();
    }

    @Override
    public void reset(@NotNull List<? extends T> items) {
        super.reset(items);
        SwingUtilities.invokeLater(() -> {
            if (!this.model.isEmpty()) {
                this.list.setSelectedIndex(0);
            }
        });
    }

    @Override
    protected void removeEmptyItem(int i2) {
        ListUtil.removeIndices((JList)this.getList(), (int[])new int[]{i2});
    }
}

