/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.progress;

import com.google.common.util.concurrent.AtomicDouble;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.intellij.util.progress.SubTaskProgressIndicator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ConcurrentTasksProgressManager {
    private final ProgressIndicator myParent;
    private final int myTotalWeight;
    private final AtomicDouble myTotalFraction;
    private final Object myLock = new Object();
    private final LinkedHashMap<SubTaskProgressIndicator, String> myText2Stack = new LinkedHashMap();
    private final AtomicInteger myRemainingTotalWeight;

    public ConcurrentTasksProgressManager(ProgressIndicator parent, int totalWeight) {
        if (totalWeight <= 0) {
            throw new IllegalArgumentException("Total weight must be a positive number: " + totalWeight);
        }
        this.myParent = parent;
        this.myTotalWeight = totalWeight;
        this.myTotalFraction = new AtomicDouble();
        this.myRemainingTotalWeight = new AtomicInteger(totalWeight);
    }

    @NotNull
    public SubTaskProgressIndicator createSubTaskIndicator(int taskWeight) {
        if (taskWeight <= 0) {
            throw new IllegalArgumentException("Task weight must be a positive number: " + taskWeight);
        }
        if (this.myRemainingTotalWeight.addAndGet(-taskWeight) < 0) {
            throw new IllegalStateException("Attempted to create more task indicators than registered in constructor");
        }
        return new SubTaskProgressIndicator(this, taskWeight);
    }

    @NotNull
    ProgressIndicator getParent() {
        return this.myParent;
    }

    void updateTaskFraction(double taskDeltaFraction, int taskWeight) {
        double newFraction = this.myTotalFraction.addAndGet(taskDeltaFraction * (double)taskWeight / (double)this.myTotalWeight);
        this.myParent.setFraction(newFraction);
    }

    public void setText(@NotNull String text) {
        this.myParent.setText(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setText2(@NotNull SubTaskProgressIndicator subTask, @Nullable String text) {
        if (text != null) {
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.put((Object)subTask, (Object)text);
            }
            this.myParent.setText2(text);
        } else {
            String prev;
            Object object = this.myLock;
            synchronized (object) {
                this.myText2Stack.remove((Object)subTask);
                prev = (String)this.myText2Stack.getLastValue();
            }
            if (prev != null) {
                this.myParent.setText2(prev);
            }
        }
    }
}

