/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.snapshot;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.ValueContainerImpl;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.snapshot.EmptyValueContainer;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnapshotSingleValueIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(SnapshotSingleValueIndexStorage.class);
    private volatile SnapshotInputMappings<Key, Value> mySnapshotInputMappings;
    private volatile IntForwardIndex myForwardIndex;
    private final Lock myCacheLock = new ReentrantLock();
    private final SLRUCache<Key, ValueContainer<Value>> myCache;
    private volatile boolean myInitialized;

    public SnapshotSingleValueIndexStorage(int cacheSize) {
        this.myCache = new SLRUCache<Key, ValueContainer<Value>>(cacheSize, (int)Math.ceil((double)cacheSize * 0.25)){

            @NotNull
            public ValueContainer<Value> createValue(Key key) {
                try {
                    return SnapshotSingleValueIndexStorage.this.doRead(key);
                }
                catch (StorageException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public void init(@NotNull SnapshotInputMappings<Key, Value> snapshotInputMappings, @NotNull IntForwardIndex forwardIndex) {
        assert (!this.myInitialized);
        this.myForwardIndex = forwardIndex;
        this.mySnapshotInputMappings = snapshotInputMappings;
        this.myInitialized = true;
    }

    @NotNull
    public ValueContainer<Value> read(Key key) throws StorageException {
        assert (this.myInitialized);
        this.myCacheLock.lock();
        try {
            ValueContainer valueContainer = (ValueContainer)this.myCache.get(key);
            return valueContainer;
        }
        finally {
            this.myCacheLock.unlock();
        }
    }

    @NotNull
    private ValueContainer<Value> doRead(Key key) throws StorageException {
        int inputId = SnapshotSingleValueIndexStorage.inputKey(key);
        try {
            int hashId = this.myForwardIndex.getInt(Integer.valueOf(inputId));
            if (hashId == 0) {
                return new ValueContainerImpl();
            }
            Object item = ContainerUtil.getFirstItem(this.mySnapshotInputMappings.readData(hashId).values());
            ValueContainerImpl container2 = new ValueContainerImpl();
            container2.addValue(inputId, item);
            return container2;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor2, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        assert (this.myInitialized);
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addValue(Key key, int inputId, Value value2) {
        assert (this.myInitialized);
        this.checkKeyInputIdConsistency(key, inputId);
        this.myCache.remove(key);
    }

    public void removeAllValues(@NotNull Key key, int inputId) {
        assert (this.myInitialized);
        this.checkKeyInputIdConsistency(key, inputId);
        this.myCache.remove(key);
    }

    public void clear() {
        this.clearCaches();
    }

    public void clearCaches() {
        this.myCacheLock.lock();
        try {
            this.myCache.clear();
        }
        finally {
            this.myCacheLock.unlock();
        }
    }

    public void close() throws StorageException {
    }

    public void flush() throws IOException {
        this.clearCaches();
    }

    private void checkKeyInputIdConsistency(Key key, int inputId) {
        if (!Comparing.equal(key, (Object)inputId)) {
            LOG.error("key (" + key + ") and inputId (" + inputId + ") should be the same for " + SingleEntryFileBasedIndexExtension.class.getName());
        }
    }

    private static <Key> int inputKey(Key key) {
        return (Integer)key;
    }

    public static <Value> ValueContainer<Value> empty() {
        return EmptyValueContainer.INSTANCE;
    }
}

