/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.memory;

import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InMemoryForwardIndex
implements ForwardIndex {
    private final TIntObjectHashMap<byte[]> myMap = new TIntObjectHashMap();

    @Nullable
    public synchronized ByteArraySequence get(@NotNull Integer key) throws IOException {
        byte[] bytes = (byte[])this.myMap.get(key.intValue());
        return bytes == null ? null : new ByteArraySequence(bytes);
    }

    public synchronized void put(@NotNull Integer key, @Nullable ByteArraySequence value2) {
        if (value2 == null) {
            this.myMap.remove(key.intValue());
        } else {
            this.myMap.put(key.intValue(), (Object)value2.toBytes());
        }
    }

    public void force() {
    }

    public synchronized void clear() {
        this.myMap.clear();
    }

    public void close() {
    }
}

