/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.ByteArraySequence;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.CompositeDataIndexer;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.FileContentImpl;
import com.intellij.util.indexing.FileIndexingState;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexExtension;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexedFile;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InputMapExternalizer;
import com.intellij.util.indexing.SingleEntryFileBasedIndexExtension;
import com.intellij.util.indexing.SingleEntryIndexer;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.UpdatableIndex;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.DirectInputDataDiffBuilder;
import com.intellij.util.indexing.impl.IndexDebugProperties;
import com.intellij.util.indexing.impl.IndexStorage;
import com.intellij.util.indexing.impl.InputData;
import com.intellij.util.indexing.impl.InputDataDiffBuilder;
import com.intellij.util.indexing.impl.MapReduceIndex;
import com.intellij.util.indexing.impl.forward.AbstractMapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.EmptyForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndex;
import com.intellij.util.indexing.impl.forward.ForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.IntForwardIndex;
import com.intellij.util.indexing.impl.forward.IntMapForwardIndex;
import com.intellij.util.indexing.impl.forward.MapForwardIndexAccessor;
import com.intellij.util.indexing.impl.forward.PersistentMapBasedForwardIndex;
import com.intellij.util.indexing.impl.forward.SingleEntryIndexForwardIndexAccessor;
import com.intellij.util.indexing.impl.perFileVersion.PersistentSubIndexerRetriever;
import com.intellij.util.indexing.impl.storage.TransientChangesIndexStorage;
import com.intellij.util.indexing.memory.InMemoryForwardIndex;
import com.intellij.util.indexing.snapshot.IndexImporterMappingIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappingIndex;
import com.intellij.util.indexing.snapshot.SnapshotInputMappings;
import com.intellij.util.indexing.snapshot.SnapshotSingleValueIndexStorage;
import com.intellij.util.indexing.snapshot.UpdatableSnapshotInputMappingIndex;
import com.intellij.util.io.IOUtil;
import gnu.trove.THashSet;
import gnu.trove.TIntObjectHashMap;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VfsAwareMapReduceIndex<Key, Value>
extends MapReduceIndex<Key, Value, FileContent>
implements UpdatableIndex<Key, Value, FileContent> {
    private static final Logger LOG = Logger.getInstance(VfsAwareMapReduceIndex.class);
    @ApiStatus.Internal
    public static final int VERSION = 0;
    private final AtomicBoolean myInMemoryMode = new AtomicBoolean();
    private final TIntObjectHashMap<Map<Key, Value>> myInMemoryKeysAndValues = new TIntObjectHashMap();
    private final PersistentSubIndexerRetriever mySubIndexerRetriever;
    private final SnapshotInputMappingIndex<Key, Value, FileContent> mySnapshotInputMappings;
    private final boolean myUpdateMappings;
    private final boolean mySingleEntryIndex;

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage) throws IOException {
        this(extension, storage, VfsAwareMapReduceIndex.hasSnapshotMapping(extension) ? new SnapshotInputMappings<Key, Value>(extension, VfsAwareMapReduceIndex.getForwardIndexAccessor(extension)) : null);
        if (!(this.myIndexId instanceof ID)) {
            throw new IllegalArgumentException("myIndexId should be instance of com.intellij.util.indexing.ID");
        }
    }

    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable SnapshotInputMappings<Key, Value> snapshotInputMappings) throws IOException {
        this(extension, storage, (ForwardIndex)(snapshotInputMappings != null ? new IntMapForwardIndex(snapshotInputMappings.getInputIndexStorageFile(), true) : VfsAwareMapReduceIndex.getForwardIndexMap(extension)), (ForwardIndexAccessor<Key, Value>)(snapshotInputMappings != null ? snapshotInputMappings.getForwardIndexAccessor() : VfsAwareMapReduceIndex.getForwardIndexAccessor(extension)), snapshotInputMappings, null);
    }

    /*
     * Unable to fully structure code
     */
    public VfsAwareMapReduceIndex(@NotNull IndexExtension<Key, Value, FileContent> extension, @NotNull IndexStorage<Key, Value> storage, @Nullable ForwardIndex forwardIndexMap, @Nullable ForwardIndexAccessor<Key, Value> forwardIndexAccessor, @Nullable SnapshotInputMappings<Key, Value> snapshotInputMappings, @Nullable ReadWriteLock lock) {
        super(extension, storage, forwardIndexMap, forwardIndexAccessor, lock);
        if (storage instanceof TransientChangesIndexStorage && snapshotInputMappings != null && (backendStorage = ((TransientChangesIndexStorage)storage).getBackendStorage()) instanceof SnapshotSingleValueIndexStorage) {
            VfsAwareMapReduceIndex.LOG.assertTrue(forwardIndexMap instanceof IntForwardIndex);
            ((SnapshotSingleValueIndexStorage)backendStorage).init(snapshotInputMappings, (IntForwardIndex)forwardIndexMap);
        }
        if (VfsAwareMapReduceIndex.isCompositeIndexer(this.myIndexer)) {
            try {
                this.mySubIndexerRetriever = new PersistentSubIndexerRetriever<SubIndexerType, SubIndexerVersion>((ID)this.myIndexId, extension.getVersion(), (CompositeDataIndexer)this.myIndexer);
                if (snapshotInputMappings == null) ** GOTO lbl17
                snapshotInputMappings.setSubIndexerRetriever(this.mySubIndexerRetriever);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.mySubIndexerRetriever = null;
        }
lbl17:
        // 3 sources

        this.mySnapshotInputMappings = IndexImporterMappingIndex.wrap(snapshotInputMappings, extension);
        this.myUpdateMappings = this.mySnapshotInputMappings instanceof UpdatableSnapshotInputMappingIndex;
        this.mySingleEntryIndex = extension instanceof SingleEntryFileBasedIndexExtension;
        this.installMemoryModeListener();
    }

    @Override
    public void dumpStatistics() {
        if (this.mySnapshotInputMappings instanceof SnapshotInputMappings) {
            ((SnapshotInputMappings)this.mySnapshotInputMappings).dumpStatistics();
        }
    }

    public static boolean isCompositeIndexer(@NotNull DataIndexer<?, ?, ?> indexer) {
        return indexer instanceof CompositeDataIndexer && !FileBasedIndex.USE_IN_MEMORY_INDEX;
    }

    public static <Key, Value> boolean hasSnapshotMapping(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        return indexExtension instanceof FileBasedIndexExtension && ((FileBasedIndexExtension)indexExtension).hasSnapshotMapping() && FileBasedIndex.ourSnapshotMappingsEnabled && !FileBasedIndex.USE_IN_MEMORY_INDEX;
    }

    @NotNull
    protected InputData<Key, Value> mapInput(int inputId, @Nullable FileContent content2) {
        InputData<Key, Value> data2;
        boolean isPhysical;
        boolean containsSnapshotData = true;
        boolean bl = isPhysical = content2 instanceof FileContentImpl && ((FileContentImpl)content2).isPhysicalContent();
        if (this.mySnapshotInputMappings != null && isPhysical) {
            try {
                data2 = this.mySnapshotInputMappings.readData(content2);
                if (data2 != null) {
                    return data2;
                }
                containsSnapshotData = !this.myUpdateMappings;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        data2 = super.mapInput(inputId, (Object)content2);
        if (!containsSnapshotData) {
            try {
                return ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).putData(content2, data2);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return data2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    protected InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId) throws IOException {
        if (this.mySnapshotInputMappings != null && !this.myInMemoryMode.get()) {
            return super.getKeysDiffBuilder(inputId);
        }
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                Map keysAndValues = (Map)this.myInMemoryKeysAndValues.get(inputId);
                if (keysAndValues != null) {
                    return this.getKeysDiffBuilder(inputId, keysAndValues);
                }
            }
        }
        return super.getKeysDiffBuilder(inputId);
    }

    @NotNull
    public InputDataDiffBuilder<Key, Value> getKeysDiffBuilder(int inputId, @NotNull Map<Key, Value> keysAndValues) throws IOException {
        return ((AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor()).createDiffBuilderByMap(inputId, keysAndValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateForwardIndex(int inputId, @NotNull InputData<Key, Value> data2) throws IOException {
        if (this.myInMemoryMode.get()) {
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                this.myInMemoryKeysAndValues.put(inputId, (Object)data2.getKeyValues());
            }
        } else {
            super.updateForwardIndex(inputId, data2);
        }
    }

    @Override
    public void setIndexedStateForFile(int fileId, @NotNull IndexedFile file2) {
        IndexingStamp.setFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.setIndexedState(fileId, file2);
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    @Override
    public void resetIndexedStateForFile(int fileId) {
        IndexingStamp.setFileIndexedStateOutdated(fileId, (ID)this.myIndexId);
    }

    @Override
    @NotNull
    public FileIndexingState getIndexingStateForFile(int fileId, @NotNull IndexedFile file2) {
        FileIndexingState baseState = IndexingStamp.isFileIndexedStateCurrent(fileId, (ID)this.myIndexId);
        if (baseState != FileIndexingState.UP_TO_DATE) {
            return baseState;
        }
        if (this.mySubIndexerRetriever == null) {
            return FileIndexingState.UP_TO_DATE;
        }
        if (!(file2 instanceof FileContent) && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
            return this.isIndexConfigurationUpToDate(fileId, file2) ? FileIndexingState.UP_TO_DATE : FileIndexingState.OUT_DATED;
        }
        try {
            if (this.mySubIndexerRetriever.isIndexed(fileId, file2)) {
                if (file2 instanceof FileContent && ((CompositeDataIndexer)this.myIndexer).requiresContentForSubIndexerEvaluation(file2)) {
                    this.setIndexConfigurationUpToDate(fileId, file2);
                }
                return FileIndexingState.UP_TO_DATE;
            }
            return FileIndexingState.OUT_DATED;
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            return FileIndexingState.OUT_DATED;
        }
    }

    protected boolean isIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
        return false;
    }

    protected void setIndexConfigurationUpToDate(int fileId, @NotNull IndexedFile file2) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeTransientDataForFile(int inputId) {
        this.getLock().writeLock().lock();
        try {
            Map keyValueMap;
            TIntObjectHashMap<Map<Key, Value>> tIntObjectHashMap = this.myInMemoryKeysAndValues;
            synchronized (tIntObjectHashMap) {
                keyValueMap = (Map)this.myInMemoryKeysAndValues.remove(inputId);
            }
            if (keyValueMap == null) {
                return;
            }
            try {
                this.removeTransientDataForInMemoryKeys(inputId, keyValueMap);
                InputDataDiffBuilder<Key, Value> builder2 = this.getKeysDiffBuilder(inputId);
                this.removeTransientDataForKeys(inputId, this.getKeys(builder2));
            }
            catch (StorageException | IOException throwable) {
                throw new RuntimeException(throwable);
            }
        }
        finally {
            this.getLock().writeLock().unlock();
        }
    }

    protected void removeTransientDataForInMemoryKeys(int inputId, @NotNull Map<? extends Key, ? extends Value> map2) {
        this.removeTransientDataForKeys(inputId, map2.keySet());
    }

    @Override
    public void removeTransientDataForKeys(int inputId, @NotNull Collection<? extends Key> keys2) {
        TransientChangesIndexStorage memoryIndexStorage = (TransientChangesIndexStorage)this.getStorage();
        boolean modified = false;
        for (Key key : keys2) {
            if (!memoryIndexStorage.clearMemoryMapForId(key, inputId) || modified) continue;
            modified = true;
        }
        if (modified) {
            this.myModificationStamp.incrementAndGet();
        }
    }

    @Override
    public void setBufferingEnabled(boolean enabled) {
        ((TransientChangesIndexStorage)this.getStorage()).setBufferingEnabled(enabled);
    }

    @Override
    public void cleanupMemoryStorage() {
        TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)this.getStorage();
        ConcurrencyUtil.withLock((Lock)this.getLock().writeLock(), () -> {
            if (memStorage.clearMemoryMap()) {
                this.myModificationStamp.incrementAndGet();
            }
        });
        memStorage.fireMemoryStorageCleared();
    }

    @Override
    public void cleanupForNextTest() {
        TransientChangesIndexStorage memStorage = (TransientChangesIndexStorage)this.getStorage();
        ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> memStorage.clearCaches());
    }

    @Override
    public boolean processAllKeys(@NotNull Processor<? super Key> processor2, @NotNull GlobalSearchScope scope, @Nullable IdFilter idFilter) throws StorageException {
        return (Boolean)ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> ((VfsAwareIndexStorage)this.myStorage).processKeys(processor2, scope, idFilter));
    }

    @Override
    @NotNull
    public Map<Key, Value> getIndexedFileData(int fileId) throws StorageException {
        return (Map)ConcurrencyUtil.withLock((Lock)this.getLock().readLock(), () -> {
            try {
                return Collections.unmodifiableMap(ContainerUtil.notNullize(this.getNullableIndexedData(fileId)));
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        });
    }

    @Nullable
    private Map<Key, Value> getNullableIndexedData(int fileId) throws IOException, StorageException {
        Map map2;
        if (this.myInMemoryMode.get() && (map2 = (Map)this.myInMemoryKeysAndValues.get(fileId)) != null) {
            return map2;
        }
        if (this.mySingleEntryIndex) {
            Integer key = fileId;
            Map[] result2 = new Map[]{Collections.emptyMap()};
            ValueContainer container2 = this.getData(key);
            container2.forEach((id2, value2) -> {
                boolean acceptNullValues = ((SingleEntryIndexer)this.myIndexer).isAcceptNullValues();
                if (value2 != null || acceptNullValues) {
                    result2[0] = Collections.singletonMap(key, value2);
                }
                return false;
            });
            return result2[0];
        }
        if (this.getForwardIndexAccessor() instanceof AbstractMapForwardIndexAccessor) {
            ByteArraySequence serializedInputData = this.getForwardIndex().get(Integer.valueOf(fileId));
            AbstractMapForwardIndexAccessor forwardIndexAccessor = (AbstractMapForwardIndexAccessor)this.getForwardIndexAccessor();
            return forwardIndexAccessor.convertToInputDataMap(fileId, serializedInputData);
        }
        LOG.error("Can't fetch indexed data for index " + this.myIndexId.getName());
        return null;
    }

    public void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    protected void requestRebuild(@NotNull Throwable ex) {
        Runnable action2 = () -> FileBasedIndex.getInstance().requestRebuild((ID)this.myIndexId, ex);
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || application.isHeadlessEnvironment()) {
            ApplicationManager.getApplication().invokeLater(action2);
        } else {
            action2.run();
        }
    }

    protected void doClear() throws StorageException, IOException {
        super.doClear();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            try {
                ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
        if (this.mySubIndexerRetriever != null) {
            try {
                this.mySubIndexerRetriever.clear();
            }
            catch (IOException e) {
                LOG.error((Throwable)e);
            }
        }
    }

    protected void doFlush() throws IOException, StorageException {
        super.doFlush();
        if (this.mySnapshotInputMappings != null && this.myUpdateMappings) {
            ((UpdatableSnapshotInputMappingIndex)this.mySnapshotInputMappings).flush();
        }
        if (this.mySubIndexerRetriever != null) {
            this.mySubIndexerRetriever.flush();
        }
    }

    protected void doDispose() throws StorageException {
        try {
            super.doDispose();
        }
        catch (Throwable throwable) {
            IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
            throw throwable;
        }
        IOUtil.closeSafe((Logger)LOG, (Closeable[])new Closeable[]{this.mySnapshotInputMappings, this.mySubIndexerRetriever});
    }

    @ApiStatus.Internal
    @NotNull
    public static <Key, Value> AbstractMapForwardIndexAccessor<Key, Value, ?> getForwardIndexAccessor(@NotNull IndexExtension<Key, Value, ?> indexExtension) {
        if (!(indexExtension instanceof SingleEntryFileBasedIndexExtension) || FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return new MapForwardIndexAccessor(new InputMapExternalizer<Key, Value>(indexExtension));
        }
        return new SingleEntryIndexForwardIndexAccessor<Value>(indexExtension);
    }

    @Nullable
    private static ForwardIndex getForwardIndexMap(@NotNull IndexExtension<?, ?, ?> indexExtension) throws IOException {
        if (!VfsAwareMapReduceIndex.shouldCreateForwardIndex(indexExtension)) {
            return null;
        }
        if (FileBasedIndex.USE_IN_MEMORY_INDEX) {
            return new InMemoryForwardIndex();
        }
        if (indexExtension instanceof SingleEntryFileBasedIndexExtension) {
            return new EmptyForwardIndex();
        }
        File indexStorageFile = IndexInfrastructure.getInputIndexStorageFile((ID)indexExtension.getName());
        return new PersistentMapBasedForwardIndex(indexStorageFile.toPath(), false, false);
    }

    private static boolean shouldCreateForwardIndex(@NotNull IndexExtension<?, ?, ?> indexExtension) {
        return !VfsAwareMapReduceIndex.hasSnapshotMapping(indexExtension);
    }

    private void installMemoryModeListener() {
        IndexStorage storage = this.getStorage();
        if (storage instanceof TransientChangesIndexStorage) {
            ((TransientChangesIndexStorage)storage).addBufferingStateListener(new TransientChangesIndexStorage.BufferingStateListener(){

                @Override
                public void bufferingStateChanged(boolean newState2) {
                    VfsAwareMapReduceIndex.this.myInMemoryMode.set(newState2);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void memoryStorageCleared() {
                    TIntObjectHashMap tIntObjectHashMap = VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues;
                    synchronized (tIntObjectHashMap) {
                        VfsAwareMapReduceIndex.this.myInMemoryKeysAndValues.clear();
                    }
                }
            });
        }
    }

    @NotNull
    private Collection<Key> getKeys(InputDataDiffBuilder<Key, ?> builder2) throws StorageException {
        if (builder2 instanceof DirectInputDataDiffBuilder) {
            return ((DirectInputDataDiffBuilder)builder2).getKeys();
        }
        LOG.error("Input data diff builder must be an instance of DirectInputDataDiffBuilder for index " + this.myIndexId.getName());
        THashSet keys2 = new THashSet();
        builder2.differentiate(Collections.emptyMap(), (key, value2, inputId) -> {}, (key, value2, inputId) -> {}, (arg_0, arg_1) -> VfsAwareMapReduceIndex.lambda$getKeys$8((Set)keys2, arg_0, arg_1));
        return keys2;
    }

    private static /* synthetic */ void lambda$getKeys$8(Set keys2, Object key, int inputId) throws StorageException {
        keys2.add(key);
    }

    static {
        if (!IndexDebugProperties.DEBUG) {
            Application app = ApplicationManager.getApplication();
            IndexDebugProperties.DEBUG = (app.isEAP() || app.isInternal()) && !ApplicationInfoImpl.isInStressTest();
        }
    }
}

