/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.impl.storage;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectAndLibrariesScope;
import com.intellij.psi.search.ProjectScopeImpl;
import com.intellij.util.Processor;
import com.intellij.util.SystemProperties;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.VfsAwareIndexStorage;
import com.intellij.util.indexing.impl.MapIndexStorage;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.DataOutputStream;
import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.keyStorage.AppendableObjectStorage;
import com.intellij.util.io.keyStorage.AppendableStorageBackedByResizableMappedFile;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class VfsAwareMapIndexStorage<Key, Value>
extends MapIndexStorage<Key, Value>
implements VfsAwareIndexStorage<Key, Value> {
    private static final Logger LOG = Logger.getInstance(MapIndexStorage.class);
    private static final boolean ENABLE_CACHED_HASH_IDS = SystemProperties.getBooleanProperty((String)"idea.index.no.cashed.hashids", (boolean)true);
    private final boolean myBuildKeyHashToVirtualFileMapping;
    private AppendableObjectStorage<int[]> myKeyHashToVirtualFileMapping;
    private volatile int myLastScannedId;
    private static final ConcurrentIntObjectMap<Boolean> ourInvalidatedSessionIds = ContainerUtil.createConcurrentIntObjectMap();
    private static volatile File mySessionDirectory;

    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean readOnly) throws IOException {
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, false, true, readOnly, null);
        this.myBuildKeyHashToVirtualFileMapping = false;
    }

    public VfsAwareMapIndexStorage(@NotNull Path storageFile, @NotNull KeyDescriptor<Key> keyDescriptor, @NotNull DataExternalizer<Value> valueExternalizer, int cacheSize, boolean keyIsUniqueForIndexedFile, boolean buildKeyHashToVirtualFileMapping) throws IOException {
        super(storageFile, keyDescriptor, valueExternalizer, cacheSize, keyIsUniqueForIndexedFile, false, false, null);
        this.myBuildKeyHashToVirtualFileMapping = buildKeyHashToVirtualFileMapping;
        this.initMapAndCache();
    }

    protected void initMapAndCache() throws IOException {
        super.initMapAndCache();
        if (this.myBuildKeyHashToVirtualFileMapping) {
            FileSystem projectFileFS = this.getProjectFile().getFileSystem();
            assert (!projectFileFS.isReadOnly()) : "File system " + projectFileFS + " is read only";
            this.myKeyHashToVirtualFileMapping = new AppendableStorageBackedByResizableMappedFile(this.getProjectFile(), 4096, null, 0x100000, true, (KeyDescriptor)IntPairInArrayKeyDescriptor.INSTANCE);
        } else {
            this.myKeyHashToVirtualFileMapping = null;
        }
    }

    protected void checkCanceled() {
        ProgressManager.checkCanceled();
    }

    @NotNull
    private Path getProjectFile() {
        return this.myBaseStorageFile.resolveSibling(this.myBaseStorageFile.getFileName() + ".project");
    }

    private <T extends Throwable> void withLock(ThrowableRunnable<T> r, boolean read) throws T {
        if (read) {
            this.myKeyHashToVirtualFileMapping.lockRead();
        } else {
            this.myKeyHashToVirtualFileMapping.lockWrite();
        }
        try {
            r.run();
        }
        finally {
            if (read) {
                this.myKeyHashToVirtualFileMapping.unlockRead();
            } else {
                this.myKeyHashToVirtualFileMapping.unlockWrite();
            }
        }
    }

    public void flush() {
        this.l.lock();
        try {
            super.flush();
            if (this.myKeyHashToVirtualFileMapping != null && this.myKeyHashToVirtualFileMapping.isDirty()) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.force(), false);
            }
        }
        finally {
            this.l.unlock();
        }
    }

    public void close() throws StorageException {
        super.close();
        try {
            this.closeKeyHashToFileMapping();
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
    }

    private void closeKeyHashToFileMapping() throws StorageException {
        if (this.myKeyHashToVirtualFileMapping != null) {
            try {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.close(), false);
            }
            catch (IOException e) {
                throw new StorageException((Throwable)e);
            }
        }
    }

    public void clear() throws StorageException {
        try {
            this.closeKeyHashToFileMapping();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                IOUtil.deleteAllFilesStartingWith((File)this.getProjectFile().toFile());
            }
        }
        catch (RuntimeException e) {
            VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
        }
        super.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processKeys(@NotNull Processor<? super Key> processor2, GlobalSearchScope scope, IdFilter idFilter) throws StorageException {
        this.l.lock();
        try {
            this.myCache.clear();
            if (this.myBuildKeyHashToVirtualFileMapping && idFilter != null) {
                IntOpenHashSet finalHashMaskSet;
                IntOpenHashSet hashMaskSet = null;
                long l = System.currentTimeMillis();
                GlobalSearchScope filterScope = idFilter.getEffectiveFilteringScope();
                GlobalSearchScope effectiveFilteringScope = filterScope != null ? filterScope : scope;
                File fileWithCaches = this.getSavedProjectFileValueIds(this.myLastScannedId, effectiveFilteringScope);
                boolean useCachedHashIds = ENABLE_CACHED_HASH_IDS && (effectiveFilteringScope instanceof ProjectScopeImpl || effectiveFilteringScope instanceof ProjectAndLibrariesScope) && fileWithCaches != null;
                int id2 = this.myKeyHashToVirtualFileMapping.getCurrentLength();
                if (useCachedHashIds && id2 == this.myLastScannedId && ourInvalidatedSessionIds.remove(id2) == null) {
                    try {
                        hashMaskSet = VfsAwareMapIndexStorage.loadHashedIds(fileWithCaches);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (hashMaskSet == null) {
                    if (useCachedHashIds && this.myLastScannedId != 0) {
                        FileUtil.asyncDelete((File)fileWithCaches);
                    }
                    finalHashMaskSet = hashMaskSet = new IntOpenHashSet(1000);
                    this.withLock(() -> this.myKeyHashToVirtualFileMapping.force(), false);
                    this.withLock(() -> this.lambda$processKeys$4(idFilter, (IntSet)finalHashMaskSet), true);
                    if (useCachedHashIds) {
                        this.saveHashedIds((IntSet)hashMaskSet, id2, effectiveFilteringScope);
                    }
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scanned keyHashToVirtualFileMapping of " + this.myBaseStorageFile + " for " + (System.currentTimeMillis() - l));
                }
                finalHashMaskSet = hashMaskSet;
                boolean bl = this.doProcessKeys(arg_0 -> this.lambda$processKeys$5((IntSet)finalHashMaskSet, processor2, arg_0));
                return bl;
            }
            boolean hashMaskSet = this.doProcessKeys(processor2);
            return hashMaskSet;
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
        catch (RuntimeException e) {
            boolean bl = (Boolean)VfsAwareMapIndexStorage.unwrapCauseAndRethrow((RuntimeException)e);
            return bl;
        }
        finally {
            this.l.unlock();
        }
    }

    @NotNull
    private static IntSet loadHashedIds(@NotNull File fileWithCaches) throws IOException {
        try (DataInputStream inputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(fileWithCaches)));){
            int capacity;
            IntOpenHashSet hashMaskSet = new IntOpenHashSet(capacity);
            for (capacity = DataInputOutputUtil.readINT((DataInput)inputStream); capacity > 0; --capacity) {
                hashMaskSet.add(DataInputOutputUtil.readINT((DataInput)inputStream));
            }
            IntOpenHashSet intOpenHashSet = hashMaskSet;
            return intOpenHashSet;
        }
    }

    private void saveHashedIds(@NotNull IntSet hashMaskSet, int largestId, @NotNull GlobalSearchScope scope) {
        File newFileWithCaches = this.getSavedProjectFileValueIds(largestId, scope);
        assert (newFileWithCaches != null);
        boolean savedSuccessfully = true;
        try (DataOutputStream stream = new DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(newFileWithCaches)));){
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)hashMaskSet.size());
            IntIterator iterator2 = hashMaskSet.iterator();
            while (iterator2.hasNext()) {
                DataInputOutputUtil.writeINT((DataOutput)stream, (int)iterator2.nextInt());
            }
        }
        catch (IOException ignored) {
            savedSuccessfully = false;
        }
        if (savedSuccessfully) {
            this.myLastScannedId = largestId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File getSessionDir() {
        File sessionDirectory = mySessionDirectory;
        if (sessionDirectory != null) return sessionDirectory;
        Class<VfsAwareMapIndexStorage> clazz = VfsAwareMapIndexStorage.class;
        synchronized (VfsAwareMapIndexStorage.class) {
            sessionDirectory = mySessionDirectory;
            if (sessionDirectory != null) return sessionDirectory;
            try {
                mySessionDirectory = sessionDirectory = FileUtil.createTempDirectory((File)new File(PathManager.getTempPath()), (String)Long.toString(System.currentTimeMillis()), (String)"", (boolean)true);
            }
            catch (IOException ex) {
                throw new RuntimeException("Can not create temp directory", ex);
            }
            return sessionDirectory;
        }
    }

    @Nullable
    private File getSavedProjectFileValueIds(int id2, @NotNull GlobalSearchScope scope) {
        Project project = scope.getProject();
        if (project == null) {
            return null;
        }
        return new File(VfsAwareMapIndexStorage.getSessionDir(), this.getProjectFile().toFile().getName() + "." + project.hashCode() + "." + id2 + "." + scope.isSearchInLibraries());
    }

    public void addValue(Key key, int inputId, Value value2) throws StorageException {
        try {
            if (this.myKeyHashToVirtualFileMapping != null) {
                this.withLock(() -> this.myKeyHashToVirtualFileMapping.append((Object)new int[]{this.myKeyDescriptor.getHashCode(key), inputId}), false);
                int lastScannedId = this.myLastScannedId;
                if (lastScannedId != 0) {
                    ourInvalidatedSessionIds.cacheOrGet(lastScannedId, (Object)Boolean.TRUE);
                    this.myLastScannedId = 0;
                }
            }
            super.addValue(key, inputId, value2);
        }
        catch (IOException e) {
            throw new StorageException((Throwable)e);
        }
    }

    private /* synthetic */ boolean lambda$processKeys$5(IntSet finalHashMaskSet, Processor processor2, Object key) {
        if (!finalHashMaskSet.contains(this.myKeyDescriptor.getHashCode(key))) {
            return true;
        }
        return processor2.process(key);
    }

    private /* synthetic */ void lambda$processKeys$4(IdFilter idFilter, IntSet finalHashMaskSet) throws IOException {
        ProgressManager.checkCanceled();
        this.myKeyHashToVirtualFileMapping.processAll(key -> {
            ProgressManager.checkCanceled();
            if (!idFilter.containsFileId(key[1])) {
                return true;
            }
            finalHashMaskSet.add(key[0]);
            return true;
        });
    }

    private static class IntPairInArrayKeyDescriptor
    implements KeyDescriptor<int[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private static final IntPairInArrayKeyDescriptor INSTANCE = new IntPairInArrayKeyDescriptor();

        private IntPairInArrayKeyDescriptor() {
        }

        public void save(@NotNull DataOutput out, int[] value2) throws IOException {
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2[0]);
            DataInputOutputUtil.writeINT((DataOutput)out, (int)value2[1]);
        }

        public int[] read(@NotNull DataInput in) throws IOException {
            return new int[]{DataInputOutputUtil.readINT((DataInput)in), DataInputOutputUtil.readINT((DataInput)in)};
        }

        public int getHashCode(int[] value2) {
            return value2[0] * 31 + value2[1];
        }

        public boolean isEqual(int[] val1, int[] val2) {
            return val1[0] == val2[0] && val1[1] == val2[1];
        }
    }
}

