/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.diagnostic;

import com.fasterxml.jackson.databind.ObjectWriter;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.indexing.diagnostic.IndexDiagnosticDumper;
import com.intellij.util.indexing.diagnostic.ProjectIndexingHistory;
import com.intellij.util.indexing.diagnostic.dto.JsonIndexDiagnostic;
import com.intellij.util.io.PathKt;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Comparator;
import java.util.Set;
import java.util.stream.Stream;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.streams.jdk8.StreamsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\t\u001a\n \b*\u0004\u0018\u00010\n0\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0013"}, d2={"Lcom/intellij/util/indexing/diagnostic/IndexDiagnosticDumper;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "diagnosticDateTimeFormatter", "Ljava/time/format/DateTimeFormatter;", "kotlin.jvm.PlatformType", "jacksonMapper", "Lcom/fasterxml/jackson/databind/ObjectWriter;", "getJacksonMapper", "()Lcom/fasterxml/jackson/databind/ObjectWriter;", "jacksonMapper$delegate", "Lkotlin/Lazy;", "dumpProjectIndexingHistoryToLogSubdirectory", "", "projectIndexingHistory", "Lcom/intellij/util/indexing/diagnostic/ProjectIndexingHistory;", "intellij.platform.lang.impl"})
public final class IndexDiagnosticDumper {
    private static final Logger LOG;
    private static final Lazy jacksonMapper$delegate;
    private static final DateTimeFormatter diagnosticDateTimeFormatter;
    public static final IndexDiagnosticDumper INSTANCE;

    private final ObjectWriter getJacksonMapper() {
        Lazy lazy = jacksonMapper$delegate;
        IndexDiagnosticDumper indexDiagnosticDumper = this;
        Object var3_3 = null;
        boolean bl = false;
        return (ObjectWriter)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void dumpProjectIndexingHistoryToLogSubdirectory(@NotNull ProjectIndexingHistory projectIndexingHistory) {
        String logPath = PathManager.getLogPath();
        try {
            Object files22;
            Path indexDiagnosticDirectory = Paths.get(logPath, new String[0]).resolve("indexing-time-diagnostic");
            PathKt.createDirectories((Path)indexDiagnosticDirectory);
            String fileNamePrefix = "diagnostic-";
            String timestamp = LocalDateTime.now().format(diagnosticDateTimeFormatter);
            Path diagnosticJson = indexDiagnosticDirectory.resolve(fileNamePrefix + timestamp + ".json");
            JsonIndexDiagnostic jsonIndexDiagnostic = JsonIndexDiagnostic.Companion.generateForHistory(projectIndexingHistory);
            this.getJacksonMapper().writeValue(diagnosticJson.toFile(), (Object)jsonIndexDiagnostic);
            int limitOfHistories = 20;
            AutoCloseable autoCloseable = Files.list(indexDiagnosticDirectory);
            boolean bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                files22 = (Stream)autoCloseable;
                boolean bl3 = false;
                Sequence $this$sortedByDescending$iv = SequencesKt.filter((Sequence)StreamsKt.asSequence((Stream)files22), (Function1)((Function1)new Function1<Path, Boolean>(fileNamePrefix, limitOfHistories){
                    final /* synthetic */ String $fileNamePrefix$inlined;
                    final /* synthetic */ int $limitOfHistories$inlined;
                    {
                        this.$fileNamePrefix$inlined = string;
                        this.$limitOfHistories$inlined = n;
                        super(1);
                    }

                    public final boolean invoke(Path it) {
                        return StringsKt.startsWith$default((String)((Object)it.getFileName()).toString(), (String)this.$fileNamePrefix$inlined, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)((Object)it.getFileName()).toString(), (String)".json", (boolean)false, (int)2, null);
                    }
                }));
                boolean $i$f$sortedByDescending = false;
                boolean bl4 = false;
                files22 = SequencesKt.toSet((Sequence)SequencesKt.take((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator<T>(fileNamePrefix, limitOfHistories){
                    final /* synthetic */ String $fileNamePrefix$inlined;
                    final /* synthetic */ int $limitOfHistories$inlined;
                    {
                        this.$fileNamePrefix$inlined = string;
                        this.$limitOfHistories$inlined = n;
                    }

                    public final int compare(T a, T b) {
                        LocalDateTime localDateTime;
                        boolean bl = false;
                        Path file2 = (Path)b;
                        boolean bl2 = false;
                        String timeStamp = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((Object)file2.getFileName()).toString(), (String)this.$fileNamePrefix$inlined, null, (int)2, null), (String)".json", null, (int)2, null);
                        try {
                            localDateTime = LocalDateTime.parse(timeStamp, IndexDiagnosticDumper.access$getDiagnosticDateTimeFormatter$p(IndexDiagnosticDumper.INSTANCE));
                        }
                        catch (DateTimeParseException e) {
                            localDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
                        }
                        file2 = (Path)a;
                        Comparable comparable = localDateTime;
                        bl2 = false;
                        timeStamp = StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)((Object)file2.getFileName()).toString(), (String)this.$fileNamePrefix$inlined, null, (int)2, null), (String)".json", null, (int)2, null);
                        try {
                            localDateTime = LocalDateTime.parse(timeStamp, IndexDiagnosticDumper.access$getDiagnosticDateTimeFormatter$p(IndexDiagnosticDumper.INSTANCE));
                        }
                        catch (DateTimeParseException e) {
                            localDateTime = LocalDateTime.ofEpochSecond(0L, 0, ZoneOffset.UTC);
                        }
                        LocalDateTime localDateTime2 = localDateTime;
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)localDateTime2);
                    }
                }), (int)limitOfHistories));
            }
            catch (Throwable files22) {
                throwable = files22;
                throw files22;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
            Object survivedHistories = files22;
            autoCloseable = Files.list(indexDiagnosticDirectory);
            bl = false;
            boolean bl5 = false;
            Throwable throwable2 = null;
            try {
                files22 = (Stream)autoCloseable;
                boolean bl6 = false;
                Sequence $this$forEach$iv = SequencesKt.filterNot((Sequence)StreamsKt.asSequence((Stream)files22), (Function1)((Function1)new Function1<Path, Boolean>((Set)survivedHistories){
                    final /* synthetic */ Set $survivedHistories$inlined;
                    {
                        this.$survivedHistories$inlined = set;
                        super(1);
                    }

                    public final boolean invoke(Path it) {
                        return this.$survivedHistories$inlined.contains(it);
                    }
                }));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Path it = (Path)element$iv;
                    boolean bl7 = false;
                    PathKt.delete$default((Path)it, (boolean)false, (int)1, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable2);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to dump index diagnostic", (Throwable)e);
        }
    }

    private IndexDiagnosticDumper() {
    }

    static {
        IndexDiagnosticDumper indexDiagnosticDumper;
        INSTANCE = indexDiagnosticDumper = new IndexDiagnosticDumper();
        LOG = Logger.getInstance(IndexDiagnosticDumper.class);
        jacksonMapper$delegate = LazyKt.lazy((Function0)jacksonMapper.2.INSTANCE);
        diagnosticDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss");
    }

    public static final /* synthetic */ DateTimeFormatter access$getDiagnosticDateTimeFormatter$p(IndexDiagnosticDumper $this) {
        IndexDiagnosticDumper indexDiagnosticDumper = $this;
        return diagnosticDateTimeFormatter;
    }
}

