/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectLocator;
import com.intellij.openapi.util.io.FileTooBigException;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.contentQueue.CachedFileContent;
import com.intellij.util.indexing.contentQueue.CachedFileContentLoader;
import com.intellij.util.indexing.contentQueue.FailedToLoadContentException;
import com.intellij.util.indexing.contentQueue.TooLargeContentException;
import org.jetbrains.annotations.NotNull;

public class CurrentProjectHintedCachedFileContentLoader
implements CachedFileContentLoader {
    private final Project myProject;

    public CurrentProjectHintedCachedFileContentLoader(Project project) {
        this.myProject = project;
    }

    @Override
    @NotNull
    public CachedFileContent loadContent(@NotNull VirtualFile file2) throws FailedToLoadContentException, TooLargeContentException {
        CachedFileContent content2 = new CachedFileContent(file2);
        if (file2.isDirectory() || !file2.isValid() || file2.is(VFileProperty.SPECIAL) || VfsUtilCore.isBrokenLink((VirtualFile)file2)) {
            content2.setEmptyContent();
            return content2;
        }
        try {
            ProjectLocator.computeWithPreferredProject((VirtualFile)file2, (Project)this.myProject, () -> content2.getBytes());
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (FileTooBigException e) {
            throw new TooLargeContentException(file2);
        }
        catch (Throwable e) {
            throw new FailedToLoadContentException(file2, e);
        }
        return content2;
    }
}

