/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing.contentQueue;

import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class CachedFileContent
extends UserDataHolderBase {
    private final VirtualFile myVirtualFile;
    private long myLength;
    private byte[] myCachedBytes;
    private long myCachedTimeStamp = -1L;
    private Boolean myCachedWritable;

    public CachedFileContent(@NotNull VirtualFile virtualFile) {
        this.myVirtualFile = virtualFile;
        this.myLength = virtualFile.getLength();
    }

    public byte @NotNull [] getBytes() throws IOException {
        if (this.myCachedBytes == null) {
            if (this.myVirtualFile.isValid()) {
                this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
                this.myCachedBytes = this.myVirtualFile.contentsToByteArray(false);
            } else {
                this.myCachedTimeStamp = -1L;
                this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
            }
        }
        return this.myCachedBytes;
    }

    public void setEmptyContent() {
        this.myCachedBytes = ArrayUtilRt.EMPTY_BYTE_ARRAY;
        this.myLength = 0L;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public long getLength() {
        return this.myLength;
    }

    public long getTimeStamp() {
        if (this.myCachedTimeStamp == -1L) {
            this.myCachedTimeStamp = this.myVirtualFile.getTimeStamp();
        }
        return this.myCachedTimeStamp;
    }

    public boolean isWritable() {
        if (this.myCachedWritable == null) {
            this.myCachedWritable = this.myVirtualFile.isWritable();
        }
        return this.myCachedWritable == Boolean.TRUE;
    }
}

