/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.indexing.FileBasedIndexDataInitialization;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexConfiguration;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.UpdateTask;
import gnu.trove.THashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

class RegisteredIndexes {
    private static final Logger LOG = Logger.getInstance(RegisteredIndexes.class);
    @NotNull
    private final FileDocumentManager myFileDocumentManager;
    @NotNull
    private final FileBasedIndexImpl myFileBasedIndex;
    @NotNull
    private final Future<IndexConfiguration> myStateFuture;
    private final List<ID<?, ?>> myIndicesForDirectories = new SmartList();
    private final Set<ID<?, ?>> myNotRequiringContentIndices = new THashSet();
    private final Set<ID<?, ?>> myRequiringContentIndices = new THashSet();
    private final Set<ID<?, ?>> myPsiDependentIndices = new THashSet();
    private final Set<FileType> myNoLimitCheckTypes = new THashSet();
    private volatile boolean myExtensionsRelatedDataWasLoaded;
    private volatile boolean myInitialized;
    private volatile IndexConfiguration myState;
    private volatile Future<?> myAllIndicesInitializedFuture;
    private final Map<ID<?, ?>, DocumentUpdateTask> myUnsavedDataUpdateTasks = new ConcurrentHashMap();
    private final AtomicBoolean myShutdownPerformed = new AtomicBoolean(false);

    RegisteredIndexes(@NotNull FileDocumentManager fileDocumentManager, @NotNull FileBasedIndexImpl fileBasedIndex) {
        this.myFileDocumentManager = fileDocumentManager;
        this.myFileBasedIndex = fileBasedIndex;
        this.myStateFuture = IndexInfrastructure.submitGenesisTask(new FileBasedIndexDataInitialization(fileBasedIndex, this));
        if (!IndexInfrastructure.ourDoAsyncIndicesInitialization) {
            this.waitUntilIndicesAreInitialized();
        }
    }

    boolean performShutdown() {
        return this.myShutdownPerformed.compareAndSet(false, true);
    }

    void setState(@NotNull IndexConfiguration state) {
        this.myState = state;
    }

    IndexConfiguration getState() {
        return this.myState;
    }

    IndexConfiguration getConfigurationState() {
        IndexConfiguration state = this.myState;
        if (state == null) {
            try {
                this.myState = state = this.myStateFuture.get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
        }
        return state;
    }

    void waitUntilAllIndicesAreInitialized() {
        try {
            this.waitUntilIndicesAreInitialized();
            this.myAllIndicesInitializedFuture.get();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void waitUntilIndicesAreInitialized() {
        try {
            this.myStateFuture.get();
        }
        catch (Throwable t) {
            LOG.error(t);
        }
    }

    void extensionsDataWasLoaded() {
        this.myExtensionsRelatedDataWasLoaded = true;
    }

    void markInitialized() {
        this.myInitialized = true;
    }

    void ensureLoadedIndexesUpToDate() {
        this.myAllIndicesInitializedFuture = IndexInfrastructure.submitGenesisTask(() -> {
            if (!this.myShutdownPerformed.get()) {
                this.myFileBasedIndex.getChangedFilesCollector().ensureUpToDateAsync();
            }
            return null;
        });
    }

    void registerIndexExtension(@NotNull FileBasedIndexExtension<?, ?> extension) {
        ID name = extension.getName();
        this.myUnsavedDataUpdateTasks.put(name, new DocumentUpdateTask(name));
        if (!extension.dependsOnFileContent()) {
            if (extension.indexDirectories()) {
                this.myIndicesForDirectories.add(name);
            }
            this.myNotRequiringContentIndices.add(name);
        } else {
            this.myRequiringContentIndices.add(name);
        }
        if (FileBasedIndexImpl.isPsiDependentIndex(extension)) {
            this.myPsiDependentIndices.add(name);
        }
        this.myNoLimitCheckTypes.addAll(extension.getFileTypesWithSizeLimitNotApplicable());
    }

    @NotNull
    Set<FileType> getNoLimitCheckFileTypes() {
        return this.myNoLimitCheckTypes;
    }

    boolean areIndexesReady() {
        return this.myStateFuture.isDone() && this.myAllIndicesInitializedFuture.isDone();
    }

    boolean isExtensionsDataLoaded() {
        return this.myExtensionsRelatedDataWasLoaded;
    }

    boolean isInitialized() {
        return this.myInitialized;
    }

    Set<ID<?, ?>> getRequiringContentIndices() {
        return this.myRequiringContentIndices;
    }

    @NotNull
    Set<ID<?, ?>> getNotRequiringContentIndices() {
        return this.myNotRequiringContentIndices;
    }

    boolean isNotRequiringContentIndex(@NotNull ID<?, ?> indexId) {
        return this.myNotRequiringContentIndices.contains(indexId);
    }

    @NotNull
    List<ID<?, ?>> getIndicesForDirectories() {
        return this.myIndicesForDirectories;
    }

    Set<ID<?, ?>> getPsiDependentIndices() {
        return this.myPsiDependentIndices;
    }

    boolean isPsiDependentIndex(@NotNull ID<?, ?> indexId) {
        return this.myPsiDependentIndices.contains(indexId);
    }

    UpdateTask<Document> getUnsavedDataUpdateTask(@NotNull ID<?, ?> indexId) {
        return this.myUnsavedDataUpdateTasks.get(indexId);
    }

    private final class DocumentUpdateTask
    extends UpdateTask<Document> {
        private final ID<?, ?> myIndexId;

        DocumentUpdateTask(ID<?, ?> indexId) {
            this.myIndexId = indexId;
        }

        @Override
        void doProcess(Document document, Project project) {
            RegisteredIndexes.this.myFileBasedIndex.indexUnsavedDocument(document, this.myIndexId, project, RegisteredIndexes.this.myFileDocumentManager.getFile(document));
        }
    }
}

