/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.indexing.IndexId;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface GlobalIndexFilter {
    public static final ExtensionPointName<GlobalIndexFilter> EP_NAME = ExtensionPointName.create((String)"com.intellij.globalIndexFilter");

    public boolean isExcludedFromIndex(@NotNull VirtualFile var1, @NotNull IndexId<?, ?> var2);

    public int getVersion();

    public boolean affectsIndex(@NotNull IndexId<?, ?> var1);

    public static boolean isExcludedFromIndexViaFilters(@NotNull VirtualFile file2, @NotNull IndexId<?, ?> indexId) {
        for (GlobalIndexFilter filter2 : EP_NAME.getExtensionList()) {
            if (!filter2.isExcludedFromIndex(file2, indexId)) continue;
            return true;
        }
        return false;
    }

    public static int getFiltersVersion(@NotNull IndexId<?, ?> indexId) {
        int result2 = 0;
        for (GlobalIndexFilter extension : EP_NAME.getExtensionList()) {
            if (!extension.affectsIndex(indexId)) continue;
            result2 += extension.getVersion();
        }
        return result2;
    }
}

