/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.diagnostic.PerformanceWatcher;
import com.intellij.ide.lightEdit.LightEdit;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.util.Processor;
import com.intellij.util.indexing.AdditionalIndexableFileSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexableFileSet;
import com.intellij.util.indexing.IndexingBundle;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.indexing.contentQueue.IndexUpdateRunner;
import java.util.Collection;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service
public final class FileBasedIndexProjectHandler
implements IndexableFileSet {
    private static final Logger LOG = Logger.getInstance(FileBasedIndexProjectHandler.class);
    private final Project myProject;
    @NotNull
    private final ProjectFileIndex myProjectFileIndex;
    @ApiStatus.Internal
    public static final int ourMinFilesToStartDumMode = Registry.intValue((String)"ide.dumb.mode.minFilesToStart", (int)20);
    private static final int ourMinFilesSizeToStartDumMode = Registry.intValue((String)"ide.dumb.mode.minFilesSizeToStart", (int)0x100000);

    private FileBasedIndexProjectHandler(@NotNull Project project) {
        this.myProject = project;
        this.myProjectFileIndex = ProjectFileIndex.getInstance((Project)this.myProject);
    }

    public boolean isInSet(@NotNull VirtualFile file2) {
        if (LightEdit.owns((Project)this.myProject)) {
            return false;
        }
        if (this.myProjectFileIndex.isInContent(file2) || this.myProjectFileIndex.isInLibrary(file2)) {
            return !FileTypeManager.getInstance().isFileIgnored(file2);
        }
        return false;
    }

    public void iterateIndexableFilesIn(@NotNull VirtualFile file2, final @NotNull ContentIterator iterator2) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)file2, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file2) {
                if (!FileBasedIndexProjectHandler.this.isInSet(file2)) {
                    return false;
                }
                iterator2.processFile(file2);
                return true;
            }
        });
    }

    @Nullable
    public static DumbModeTask createChangedFilesIndexingTask(final @NotNull Project project) {
        FileBasedIndex i2 = FileBasedIndex.getInstance();
        if (!(i2 instanceof FileBasedIndexImpl) || !IndexInfrastructure.hasIndices()) {
            return null;
        }
        final FileBasedIndexImpl index = (FileBasedIndexImpl)i2;
        if (!FileBasedIndexProjectHandler.mightHaveManyChangedFilesInProject(project, index)) {
            return null;
        }
        return new DumbModeTask(project.getService(FileBasedIndexProjectHandler.class)){

            public void performInDumbMode(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(false);
                indicator.setText(IndexingBundle.message((String)"progress.indexing.updating", (Object[])new Object[0]));
                long start2 = System.currentTimeMillis();
                Collection<VirtualFile> files2 = index.getFilesToUpdate(project);
                long calcDuration = System.currentTimeMillis() - start2;
                LOG.info("Reindexing refreshed files: " + files2.size() + " to update, calculated in " + calcDuration + "ms");
                if (!files2.isEmpty()) {
                    PerformanceWatcher.Snapshot snapshot = PerformanceWatcher.takeSnapshot();
                    int numberOfIndexingThreads = UnindexedFilesUpdater.getNumberOfIndexingThreads();
                    LOG.info("Using " + numberOfIndexingThreads + " " + StringUtil.pluralize((String)"thread", (int)numberOfIndexingThreads) + " for indexing");
                    new IndexUpdateRunner(index, UnindexedFilesUpdater.GLOBAL_INDEXING_EXECUTOR, numberOfIndexingThreads).indexFiles(project, files2, indicator);
                    snapshot.logResponsivenessSinceCreation("Reindexing refreshed files");
                }
            }

            public String toString() {
                final StringBuilder sampleOfChangedFilePathsToBeIndexed = new StringBuilder();
                index.processChangedFiles(project, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
                    int filesInProjectToBeIndexed;
                    final String projectBasePath;
                    {
                        this.projectBasePath = project.getBasePath();
                    }

                    public boolean process(VirtualFile file2) {
                        if (this.filesInProjectToBeIndexed != 0) {
                            sampleOfChangedFilePathsToBeIndexed.append(", ");
                        }
                        String filePath = file2.getPath();
                        String loggedPath = this.projectBasePath != null ? FileUtil.getRelativePath((String)this.projectBasePath, (String)filePath, (char)'/') : null;
                        loggedPath = loggedPath == null ? filePath : "%project_path%/" + loggedPath;
                        sampleOfChangedFilePathsToBeIndexed.append(loggedPath);
                        return ++this.filesInProjectToBeIndexed < ourMinFilesToStartDumMode;
                    }
                });
                return super.toString() + " [" + project + ", " + sampleOfChangedFilePathsToBeIndexed + "]";
            }
        };
    }

    private static boolean mightHaveManyChangedFilesInProject(Project project, FileBasedIndexImpl index) {
        final long start2 = System.currentTimeMillis();
        return !index.processChangedFiles(project, (Processor<? super VirtualFile>)new Processor<VirtualFile>(){
            int filesInProjectToBeIndexed;
            long sizeOfFilesToBeIndexed;

            public boolean process(VirtualFile file2) {
                ++this.filesInProjectToBeIndexed;
                if (file2.isValid() && !file2.isDirectory()) {
                    this.sizeOfFilesToBeIndexed += file2.getLength();
                }
                return this.filesInProjectToBeIndexed < ourMinFilesToStartDumMode && this.sizeOfFilesToBeIndexed < (long)ourMinFilesSizeToStartDumMode && System.currentTimeMillis() < start2 + 100L;
            }
        });
    }

    @Service
    @ApiStatus.Internal
    public static final class ProjectAdditionalIndexableFileSet
    extends AdditionalIndexableFileSet {
        public ProjectAdditionalIndexableFileSet(@NotNull Project project) {
            super(project, true);
        }
    }

    static final class FileBasedIndexProjectHandlerStartupActivity
    implements StartupActivity.RequiredForSmartMode {
        FileBasedIndexProjectHandlerStartupActivity() {
            ApplicationManager.getApplication().getMessageBus().connect().subscribe(ProjectManager.TOPIC, (Object)new ProjectManagerListener(){

                public void projectClosing(@NotNull Project project) {
                    FileBasedIndexProjectHandlerStartupActivity.removeProjectIndexableSet(project);
                }
            });
        }

        public void runActivity(final @NotNull Project project) {
            if (ApplicationManager.getApplication().isInternal()) {
                project.getMessageBus().connect().subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                    public void exitDumbMode() {
                        LOG.info("Has changed files: " + (FileBasedIndexProjectHandler.createChangedFilesIndexingTask(project) != null) + "; project=" + project);
                    }
                });
            }
            FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
            PushedFilePropertiesUpdater.getInstance((Project)project).initializeProperties();
            if (fileBasedIndex instanceof FileBasedIndexImpl) {
                DumbService.getInstance((Project)project).queueTask((DumbModeTask)new UnindexedFilesUpdater(project, IndexInfrastructure.isIndexesInitializationSuspended(), true));
            }
            for (Class<? extends IndexableFileSet> indexableSetClass : FileBasedIndexProjectHandlerStartupActivity.getProjectIndexableSetClasses()) {
                IndexableFileSet set = (IndexableFileSet)project.getService(indexableSetClass);
                fileBasedIndex.registerIndexableSet(set, project);
            }
            Disposer.register((Disposable)project, () -> FileBasedIndexProjectHandlerStartupActivity.removeProjectIndexableSet(project));
        }

        private static void removeProjectIndexableSet(@NotNull Project project) {
            ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> ReadAction.run(() -> {
                for (Class<? extends IndexableFileSet> indexableSetClass : FileBasedIndexProjectHandlerStartupActivity.getProjectIndexableSetClasses()) {
                    IndexableFileSet set = (IndexableFileSet)project.getServiceIfCreated(indexableSetClass);
                    if (set == null) continue;
                    FileBasedIndex.getInstance().removeIndexableSet(set);
                }
            }), IndexingBundle.message((String)"removing.indexable.set.project.handler", (Object[])new Object[0]), false, project);
        }

        private static Class<? extends IndexableFileSet> @NotNull [] getProjectIndexableSetClasses() {
            return new Class[]{FileBasedIndexProjectHandler.class, ProjectAdditionalIndexableFileSet.class};
        }
    }
}

