/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.indexing;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.testFramework.LightVirtualFile;
import org.jetbrains.annotations.NotNull;

class DeletedVirtualFileStub
extends LightVirtualFile
implements VirtualFileWithId {
    private final int myFileId;
    private boolean myResurrected;

    DeletedVirtualFileStub(@NotNull VirtualFileWithId original) {
        this.setOriginalFile((VirtualFile)original);
        this.myFileId = -original.getId();
    }

    public int getId() {
        return this.myFileId;
    }

    public boolean isValid() {
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof DeletedVirtualFileStub) {
            return ((DeletedVirtualFileStub)((Object)obj)).getId() == this.myFileId;
        }
        return super.equals(obj);
    }

    public boolean isResurrected() {
        return this.myResurrected;
    }

    public void setResurrected(boolean resurrected) {
        this.myResurrected = resurrected;
    }

    public int hashCode() {
        return this.myFileId;
    }

    public String toString() {
        return "invalid:" + this.getOriginalFile().toString() + ", resurrected:" + this.myResurrected;
    }

    @NotNull
    public String getUrl() {
        return "invalid:" + super.getUrl();
    }
}

