/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.hash;

import com.intellij.util.io.DifferentSerializableBytesImplyNonEqualityPolicy;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.StorageLockContext;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class ContentHashEnumerator
extends PersistentBTreeEnumerator<byte[]> {
    private static final int SIGNATURE_LENGTH = 20;

    public ContentHashEnumerator(@NotNull Path contentsHashesFile) throws IOException {
        this(contentsHashesFile, null);
    }

    public ContentHashEnumerator(@NotNull Path contentsHashesFile, @Nullable StorageLockContext storageLockContext) throws IOException {
        this(contentsHashesFile, new ContentHashesDescriptor(), 65536, storageLockContext);
    }

    private ContentHashEnumerator(@NotNull Path file2, @NotNull KeyDescriptor<byte[]> dataDescriptor, int initialSize, @Nullable StorageLockContext lockContext) throws IOException {
        super(file2, dataDescriptor, initialSize, lockContext);
        LOG.assertTrue(dataDescriptor instanceof DifferentSerializableBytesImplyNonEqualityPolicy);
    }

    public boolean hasHashFor(byte @NotNull [] value2) throws IOException {
        return this.tryEnumerate(value2) != 0;
    }

    public int enumerate(byte @NotNull [] value2) throws IOException {
        LOG.assertTrue(20 == value2.length);
        return super.enumerate((Object)value2);
    }

    protected int doWriteData(byte[] value2) throws IOException {
        return super.doWriteData((Object)value2) / 20;
    }

    public int getLargestId() {
        return super.getLargestId() / 20;
    }

    protected boolean isKeyAtIndex(byte[] value2, int idx) throws IOException {
        return super.isKeyAtIndex((Object)value2, this.addrToIndex(this.indexToAddr(idx) * 20));
    }

    public byte[] valueOf(int idx) throws IOException {
        return (byte[])super.valueOf(this.addrToIndex(this.indexToAddr(idx) * 20));
    }

    public static int getVersion() {
        return PersistentBTreeEnumerator.VERSION;
    }

    private static class ContentHashesDescriptor
    implements KeyDescriptor<byte[]>,
    DifferentSerializableBytesImplyNonEqualityPolicy {
        private ContentHashesDescriptor() {
        }

        public void save(@NotNull DataOutput out, byte[] value2) throws IOException {
            out.write(value2);
        }

        public byte[] read(@NotNull DataInput in) throws IOException {
            byte[] b = new byte[20];
            in.readFully(b);
            return b;
        }

        public int getHashCode(byte[] value2) {
            int hash = 0;
            for (int i2 = 0; i2 < 4; ++i2) {
                hash = (hash << 8) + (value2[i2] & 0xFF);
            }
            return hash;
        }

        public boolean isEqual(byte[] val1, byte[] val2) {
            return Arrays.equals(val1, val2);
        }
    }
}

