/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs;

import com.intellij.ide.IdeBundle;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.FileColorManager;
import com.intellij.ui.JBColor;
import com.intellij.ui.tabs.ColorButtonBase;
import com.intellij.ui.tabs.FileColorManagerImpl;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorSelectionComponent
extends JPanel {
    private static final String CUSTOM_COLOR_NAME = "Custom";
    private final Map<String, ColorButton> myColorToButtonMap = new LinkedHashMap<String, ColorButton>();
    private final ButtonGroup myButtonGroup = new ButtonGroup();
    private ChangeListener myChangeListener;

    public ColorSelectionComponent() {
        super(new GridLayout(1, 0, 5, 5));
        this.setOpaque(false);
    }

    public void setChangeListener(ChangeListener changeListener) {
        this.myChangeListener = changeListener;
    }

    public void setSelectedColor(String colorName) {
        AbstractButton button2 = this.myColorToButtonMap.get(colorName);
        if (button2 != null) {
            button2.setSelected(true);
        }
    }

    @NotNull
    public Collection<String> getColorNames() {
        return this.myColorToButtonMap.keySet();
    }

    @Nullable
    public String getColorName(@Nullable Color color) {
        if (color == null) {
            return null;
        }
        for (String name : this.myColorToButtonMap.keySet()) {
            if (color.getRGB() != this.myColorToButtonMap.get(name).getColor().getRGB()) continue;
            return name;
        }
        return null;
    }

    public void addCustomColorButton() {
        CustomColorButton customButton = new CustomColorButton();
        this.myButtonGroup.add(customButton);
        this.add(customButton);
        this.myColorToButtonMap.put(customButton.getText(), customButton);
    }

    public void addColorButton(@NotNull String name, @NotNull Color color) {
        ColorButton colorButton = new ColorButton(name, color);
        this.myButtonGroup.add(colorButton);
        this.add(colorButton);
        this.myColorToButtonMap.put(name, colorButton);
    }

    public void setCustomButtonColor(@NotNull Color color) {
        CustomColorButton button2 = (CustomColorButton)this.myColorToButtonMap.get(CUSTOM_COLOR_NAME);
        button2.setColor(color);
        button2.setSelected(true);
        button2.repaint();
    }

    @Nullable
    public String getSelectedColorName() {
        for (String name : this.myColorToButtonMap.keySet()) {
            ColorButton button2 = this.myColorToButtonMap.get(name);
            if (!button2.isSelected()) continue;
            if (button2 instanceof CustomColorButton) {
                String color = ColorUtil.toHex((Color)button2.getColor());
                String colorName = FileColorManagerImpl.getColorName(button2.getColor());
                return colorName == null ? color : colorName;
            }
            return name;
        }
        return null;
    }

    public void initDefault(@NotNull FileColorManager manager, @Nullable String selectedColorName) {
        for (String name : manager.getColorNames()) {
            this.addColorButton(name, Objects.requireNonNull(manager.getColor(name)));
        }
        this.addCustomColorButton();
        this.setSelectedColor(selectedColorName);
    }

    public void stateChanged() {
        if (this.myChangeListener != null) {
            this.myChangeListener.stateChanged(new ChangeEvent(this));
        }
    }

    private class CustomColorButton
    extends ColorButton {
        private CustomColorButton() {
            super(ColorSelectionComponent.CUSTOM_COLOR_NAME, (Color)JBColor.WHITE);
            this.myColor = null;
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
            Color color = ColorChooser.chooseColor((Component)this, (String)IdeBundle.message((String)"dialog.title.choose.color", (Object[])new Object[0]), (Color)this.myColor);
            if (color != null) {
                this.myColor = color;
            }
            this.setSelected(this.myColor != null);
            ColorSelectionComponent.this.stateChanged();
        }

        @Override
        protected ButtonUI createUI() {
            return new ColorButtonBase.ColorButtonUI(){

                @Override
                @Nullable
                protected Color getUnfocusedBorderColor(@NotNull ColorButtonBase button2) {
                    if (StartupUiUtil.isUnderDarcula()) {
                        return JBColor.GRAY;
                    }
                    return super.getUnfocusedBorderColor(button2);
                }
            };
        }

        @Override
        public Color getForeground() {
            return this.getModel().isSelected() ? JBColor.BLACK : JBColor.GRAY;
        }

        @Override
        @NotNull
        Color getColor() {
            return this.myColor == null ? JBColor.WHITE : this.myColor;
        }
    }

    private class ColorButton
    extends ColorButtonBase {
        protected ColorButton(String text, Color color) {
            super(text, color);
        }

        @Override
        protected void doPerformAction(ActionEvent e) {
            ColorSelectionComponent.this.stateChanged();
        }
    }
}

