/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.popup;

import com.intellij.ui.ComponentUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.HierarchyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;

public class MovablePopup {
    private final HierarchyListener myListener = event -> this.setVisible(false);
    private Runnable myOnAncestorFocusLost = null;
    private final WindowAdapter myWindowFocusAdapter = new WindowAdapter(){

        @Override
        public void windowLostFocus(WindowEvent e) {
            super.windowLostFocus(e);
            if (MovablePopup.this.myOnAncestorFocusLost != null) {
                MovablePopup.this.myOnAncestorFocusLost.run();
            }
        }
    };
    private final Component myOwner;
    private final Component myContent;
    private Rectangle myViewBounds;
    private Container myView;
    private boolean myAlwaysOnTop;
    private boolean myHeavyWeight;
    private boolean myWindowFocusable;
    private boolean myWindowShadow;

    public MovablePopup(@NotNull Component owner, @NotNull Component content2) {
        this.myOwner = owner;
        this.myContent = content2;
        this.myViewBounds = new Rectangle(content2.getPreferredSize());
        this.myHeavyWeight = true;
    }

    public void setAlwaysOnTop(boolean value2) {
        if (this.myAlwaysOnTop != value2) {
            this.myAlwaysOnTop = value2;
            this.disposeAndUpdate(true);
        }
    }

    public void onAncestorFocusLost(Runnable r) {
        this.myOnAncestorFocusLost = r;
    }

    private static void setAlwaysOnTop(@NotNull Window window, boolean value2) {
        if (value2 != window.isAlwaysOnTop()) {
            try {
                window.setAlwaysOnTop(value2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setHeavyWeight(boolean value2) {
        if (this.myHeavyWeight != value2) {
            this.myHeavyWeight = value2;
            this.disposeAndUpdate(true);
        }
    }

    public void setWindowFocusable(boolean value2) {
        if (this.myWindowFocusable != value2) {
            this.myWindowFocusable = value2;
            this.disposeAndUpdate(true);
        }
    }

    private static void setWindowFocusable(@NotNull Window window, boolean value2) {
        if (value2 != window.getFocusableWindowState()) {
            window.setFocusableWindowState(value2);
        }
    }

    public void setWindowShadow(boolean value2) {
        if (this.myWindowShadow != value2) {
            this.myWindowShadow = value2;
            this.disposeAndUpdate(true);
        }
    }

    private static void setWindowShadow(@NotNull Window window, boolean value2) {
        JRootPane root = MovablePopup.getRootPane(window);
        if (root != null) {
            root.putClientProperty("Window.shadow", value2);
        }
    }

    public void setBounds(@NotNull Rectangle bounds2) {
        this.setBounds(bounds2.x, bounds2.y, bounds2.width, bounds2.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setBounds(x, y, width, height);
        } else {
            this.setBounds(new Point(x, y), new Dimension(width, height));
        }
    }

    public void setLocation(@NotNull Point location) {
        this.setLocation(location.x, location.y);
    }

    public void setLocation(int x, int y) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setLocation(x, y);
        } else {
            this.setBounds(new Point(x, y), null);
        }
    }

    public void setSize(@NotNull Dimension size) {
        this.setSize(size.width, size.height);
    }

    public void setSize(int width, int height) {
        if (this.myViewBounds != null) {
            this.myViewBounds.setSize(width, height);
        } else {
            this.setBounds(null, new Dimension(width, height));
        }
    }

    public void setVisible(boolean visible) {
        Window owner = ComponentUtil.getWindow((Component)this.myOwner);
        if (!visible && this.myView != null) {
            this.disposeAndUpdate(false);
            if (owner != null) {
                owner.removeWindowFocusListener(this.myWindowFocusAdapter);
            }
        } else if (visible && this.myView == null) {
            JLayeredPane parent;
            if (owner != null) {
                owner.addWindowFocusListener(this.myWindowFocusAdapter);
                if (this.myHeavyWeight) {
                    JWindow view = new JWindow(owner);
                    view.setType(Window.Type.POPUP);
                    MovablePopup.setAlwaysOnTop(view, this.myAlwaysOnTop);
                    MovablePopup.setWindowFocusable(view, this.myWindowFocusable);
                    MovablePopup.setWindowShadow(view, this.myWindowShadow);
                    view.setAutoRequestFocus(false);
                    view.setFocusable(false);
                    view.setFocusableWindowState(false);
                    this.myView = view;
                } else if (owner instanceof RootPaneContainer && (parent = ((RootPaneContainer)((Object)owner)).getLayeredPane()) != null) {
                    JPanel view = new JPanel(new BorderLayout());
                    view.setVisible(false);
                    parent.add(view, JLayeredPane.POPUP_LAYER, 0);
                    this.myView = view;
                }
            }
            if (this.myView != null) {
                this.myView.add(this.myContent);
                Container container2 = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    Point location = this.myViewBounds.getLocation();
                    SwingUtilities.convertPointFromScreen(location, parent);
                    this.myViewBounds.setLocation(location);
                }
                this.myView.setBackground(UIUtil.getLabelBackground());
                this.myView.setBounds(this.myViewBounds);
                this.myView.setVisible(true);
                this.myViewBounds = null;
                this.myOwner.addHierarchyListener(this.myListener);
            }
        }
    }

    public boolean isVisible() {
        return this.myView != null && this.myView.isVisible();
    }

    private void disposeAndUpdate(boolean update2) {
        if (this.myView != null) {
            this.myOwner.removeHierarchyListener(this.myListener);
            SwingUtilities.getWindowAncestor(this.myOwner).removeWindowFocusListener(this.myWindowFocusAdapter);
            boolean visible = this.myView.isVisible();
            this.myView.setVisible(false);
            Container container2 = this.myContent.getParent();
            if (container2 != null) {
                container2.remove(this.myContent);
            }
            if (this.myView instanceof Window) {
                this.myViewBounds = this.myView.getBounds();
                ((Window)this.myView).dispose();
            } else {
                Container parent = this.myView.getParent();
                if (parent == null) {
                    this.myViewBounds = new Rectangle(this.myContent.getPreferredSize());
                } else {
                    this.myViewBounds = new Rectangle(this.myView.getBounds());
                    parent.remove(this.myView);
                    Point point = new Point(this.myViewBounds.x, this.myViewBounds.y);
                    SwingUtilities.convertPointToScreen(point, parent);
                    this.myViewBounds.x = point.x;
                    this.myViewBounds.y = point.y;
                }
            }
            this.myView = null;
            if (update2 && visible) {
                this.setVisible(true);
            }
        }
    }

    private void setBounds(Point location, Dimension size) {
        if (this.myView != null) {
            if (size == null) {
                size = this.myView.getSize();
            }
            if (location == null) {
                location = this.myView.getLocation();
            } else {
                Container parent;
                Container container2 = parent = this.myView instanceof Window ? null : this.myView.getParent();
                if (parent != null) {
                    SwingUtilities.convertPointFromScreen(location, parent);
                }
            }
            this.myView.setBounds(location.x, location.y, size.width, size.height);
            if (this.myView.isVisible()) {
                this.myView.invalidate();
                this.myView.validate();
                this.myView.repaint();
            }
        }
    }

    private static JRootPane getRootPane(Window window) {
        if (window instanceof RootPaneContainer) {
            RootPaneContainer container2 = (RootPaneContainer)((Object)window);
            return container2.getRootPane();
        }
        return null;
    }
}

