/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.content.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.TabDescriptor;
import com.intellij.ui.content.TabGroupId;
import com.intellij.ui.content.TabbedContent;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.ContentUtilEx;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Container;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TabbedContentImpl
extends ContentImpl
implements TabbedContent {
    @NotNull
    private final List<TabDescriptor> myTabs = new ArrayList<TabDescriptor>();
    @NotNull
    private final TabGroupId myId;

    public TabbedContentImpl(JComponent component2, @NotNull String displayName, boolean isPinnable, @NotNull String titlePrefix) {
        this(new TabGroupId(titlePrefix, titlePrefix), new TabDescriptor(component2, displayName), isPinnable);
    }

    public TabbedContentImpl(@NotNull TabGroupId id2, @NotNull TabDescriptor tab, boolean isPinnable) {
        super(tab.getComponent(), id2.getDisplayName(tab), isPinnable);
        this.myId = id2;
        this.myTabs.add(tab);
        Disposer.register((Disposable)this, (Disposable)tab);
    }

    @Nullable
    private TabDescriptor findTab(@NotNull JComponent c) {
        for (TabDescriptor tab : this.myTabs) {
            if (tab.getComponent() != c) continue;
            return tab;
        }
        return null;
    }

    @Nullable
    private TabDescriptor selectedTab() {
        return this.findTab(this.getComponent());
    }

    private int indexOf(@NotNull JComponent c) {
        for (int i2 = 0; i2 < this.myTabs.size(); ++i2) {
            if (this.myTabs.get(i2).getComponent() != c) continue;
            return i2;
        }
        return -1;
    }

    private void selectTab(@NotNull TabDescriptor tab) {
        this.setDisplayName(this.myId.getDisplayName(tab));
        this.setComponent(tab.getComponent());
    }

    public void addContent(@NotNull JComponent content2, @NotNull String name, boolean selectTab) {
        this.addContent(new TabDescriptor(content2, name), selectTab);
    }

    public void addContent(@NotNull TabDescriptor tab, boolean selectTab) {
        Disposer.register((Disposable)this, (Disposable)tab);
        if (!this.myTabs.contains(tab)) {
            this.myTabs.add(tab);
        }
        if (selectTab && this.getComponent() != tab.getComponent()) {
            this.selectTab(tab);
        }
    }

    @NotNull
    public TabGroupId getId() {
        return this.myId;
    }

    @Nls
    @NotNull
    public String getTitlePrefix() {
        return this.myId.getDisplayName();
    }

    @Override
    public void setComponent(JComponent component2) {
        Container parent;
        JComponent currentComponent = this.getComponent();
        Container container2 = parent = currentComponent == null ? null : currentComponent.getParent();
        if (parent != null) {
            parent.remove(currentComponent);
            parent.add(component2);
        }
        super.setComponent(component2);
    }

    public void removeContent(@NotNull JComponent content2) {
        int index = this.indexOf(content2);
        if (index != -1) {
            Disposer.dispose((Disposable)((Disposable)this.myTabs.remove(index)));
            int n = index = index > 0 ? index - 1 : index;
            if (index < this.myTabs.size()) {
                this.selectContent(index);
            }
        }
    }

    @Override
    @Nls
    public String getDisplayName() {
        TabDescriptor selectedTab = this.selectedTab();
        if (selectedTab == null) {
            return this.myId.getDisplayName();
        }
        return this.myId.getDisplayName(selectedTab);
    }

    public void selectContent(int index) {
        this.selectTab(this.myTabs.get(index));
    }

    public int getSelectedIndex() {
        return this.indexOf(this.getComponent());
    }

    public boolean findAndSelectContent(@NotNull JComponent contentComponent) {
        TabDescriptor tab = this.findTab(contentComponent);
        if (tab != null) {
            this.selectTab(tab);
            return true;
        }
        return false;
    }

    @Override
    public String getTabName() {
        return this.getDisplayName();
    }

    @NotNull
    public List<Pair<String, JComponent>> getTabs() {
        return ContainerUtil.map2List(this.myTabs, tab -> Pair.create((Object)tab.getDisplayName(), (Object)tab.getComponent()));
    }

    public boolean hasMultipleTabs() {
        return this.myTabs.size() > 1;
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key.equals((Object)TAB_GROUP_ID_KEY)) {
            return (T)this.myId;
        }
        if (key.equals((Object)TAB_DESCRIPTOR_KEY)) {
            return (T)this.selectedTab();
        }
        return (T)super.getUserData(key);
    }

    public void split() {
        ContentManager manager = this.getManager();
        if (manager == null) {
            return;
        }
        boolean selected2 = manager.isSelected((Content)this);
        TabDescriptor selectedTab = this.selectedTab();
        ArrayList<TabDescriptor> tabsCopy = new ArrayList<TabDescriptor>(this.myTabs);
        manager.removeContent((Content)this, false);
        ContentUtilEx.setSplitMode(this.myId.getId(), true);
        for (TabDescriptor tab : tabsCopy) {
            ContentUtilEx.addSplitTabbedContent(manager, this.myId, tab, selected2 && tab == selectedTab);
        }
        Disposer.dispose((Disposable)this);
    }
}

