/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.AtomicNullableLazyValue;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.GrowlNotifications;
import com.intellij.ui.LibNotifyWrapper;
import com.intellij.ui.MountainLionNotifications;
import com.intellij.ui.SystemNotifications;
import com.intellij.ui.SystemTrayNotifications;
import com.intellij.util.SystemProperties;
import org.jetbrains.annotations.NotNull;

public class SystemNotificationsImpl
extends SystemNotifications {
    private final NullableLazyValue<Notifier> myNotifier = AtomicNullableLazyValue.createValue(SystemNotificationsImpl::getPlatformNotifier);

    @Override
    public void notify(@NotNull String notificationName, @NotNull String title, @NotNull String text) {
        Notifier notifier;
        if (NotificationsConfigurationImpl.getInstanceImpl().SYSTEM_NOTIFICATIONS && !ApplicationManager.getApplication().isActive() && (notifier = (Notifier)this.myNotifier.getValue()) != null) {
            notifier.notify(notificationName, title, text);
        }
    }

    private static Notifier getPlatformNotifier() {
        try {
            if (SystemInfo.isMac) {
                if (SystemInfo.isMacOSMountainLion && SystemProperties.getBooleanProperty((String)"ide.mac.mountain.lion.notifications.enabled", (boolean)true)) {
                    return MountainLionNotifications.getInstance();
                }
                return GrowlNotifications.getInstance();
            }
            if (SystemInfo.isXWindow) {
                return LibNotifyWrapper.getInstance();
            }
            if (SystemInfo.isWin10OrNewer) {
                return SystemTrayNotifications.getWin10Instance();
            }
        }
        catch (Throwable t) {
            Logger logger = Logger.getInstance(SystemNotifications.class);
            if (logger.isDebugEnabled()) {
                logger.debug(t);
            }
            logger.info(t.getMessage());
        }
        return null;
    }

    static interface Notifier {
        public void notify(@NotNull String var1, @NotNull String var2, @NotNull String var3);
    }
}

