/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.Icon;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StatusPanel
extends JBPanel {
    private final ReentrantLock myLock = new ReentrantLock();
    @Nullable
    private String myError;
    @Nullable
    private Action myCurrentAction;

    public StatusPanel() {
        super((LayoutManager)new BorderLayout());
        this.setVisible(false);
    }

    public void resetState() {
        this.myLock.lock();
        try {
            this.cancelCurrentAction();
            this.clearUI();
        }
        finally {
            this.myLock.unlock();
        }
    }

    @NotNull
    public Action progress(@NotNull String message) {
        return this.progress(message, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Action progress(@NotNull String message, boolean addProgressIconBelow) {
        this.myLock.lock();
        try {
            Action action2;
            this.cancelCurrentAction();
            this.myCurrentAction = action2 = new Action();
            this.invokeLater(() -> {
                this.clearUI();
                if (addProgressIconBelow) {
                    AsyncProcessIcon asyncProcessIcon = new AsyncProcessIcon(message);
                    this.add((Component)asyncProcessIcon, "Center");
                    this.setVisible(true);
                    asyncProcessIcon.resume();
                }
                this.refreshUI();
            });
            Action action3 = action2;
            return action3;
        }
        finally {
            this.myLock.unlock();
        }
    }

    private void cancelCurrentAction() {
        if (this.myCurrentAction != null) {
            this.myCurrentAction.cancel();
            this.myCurrentAction = null;
        }
    }

    private void clearUI() {
        this.myError = null;
        this.removeAll();
        this.setVisible(false);
        this.refreshUI();
    }

    private void refreshUI() {
        this.revalidate();
        this.repaint();
    }

    private void showMessage(@NotNull String message, @NotNull JBColor color, @Nullable Icon statusIcon) {
        this.removeAll();
        this.setVisible(true);
        JBLabel label2 = new JBLabel(message);
        label2.setText(XmlStringUtil.wrapInHtml((CharSequence)("<font color='#" + ColorUtil.toHex((Color)color) + "'><left>" + message + "</left></b></font>")));
        label2.setIcon(statusIcon);
        label2.setBorder((Border)new EmptyBorder(4, 10, 0, 2));
        this.add((Component)label2, "Center");
        this.refreshUI();
    }

    private void invokeLater(@NotNull Runnable runnable2) {
        ApplicationManager.getApplication().invokeLater(runnable2, ModalityState.stateForComponent((Component)((Object)this)));
    }

    @Nullable
    public String getError() {
        return this.myError;
    }

    public class Action {
        private volatile boolean myCancelled = false;
        private final AtomicBoolean myCompleted = new AtomicBoolean(false);

        private boolean checkIsInProgressAndComplete() {
            return this.myCompleted.compareAndSet(false, true) && !this.myCancelled;
        }

        private void cancel() {
            this.myCancelled = true;
        }

        public void done() {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(() -> {
                    StatusPanel.this.myLock.lock();
                    try {
                        if (!this.myCancelled) {
                            StatusPanel.this.clearUI();
                        }
                    }
                    finally {
                        StatusPanel.this.myLock.unlock();
                    }
                });
            }
        }

        public void doneWithResult(@NotNull String message) {
            this.showMessageOnce(message, false);
        }

        public void failed(@Nullable String message) {
            this.showMessageOnce(message, true);
        }

        private void showMessageOnce(@Nullable String message, boolean isError) {
            if (this.checkIsInProgressAndComplete()) {
                StatusPanel.this.invokeLater(() -> {
                    StatusPanel.this.myLock.lock();
                    try {
                        if (!this.myCancelled) {
                            JBColor color = isError ? JBColor.RED : JBColor.DARK_GRAY;
                            Icon statusIcon = isError ? AllIcons.Actions.Lightning : AllIcons.General.InspectionsOK;
                            StatusPanel.this.myError = isError ? message : null;
                            StatusPanel.this.showMessage(StringUtil.notNullize((String)message), color, statusIcon);
                        }
                    }
                    finally {
                        StatusPanel.this.myLock.unlock();
                    }
                });
            }
        }
    }
}

